/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.script;

import cool.taomu.framework.inter.IScript;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class JsRhinoScript implements IScript {
  private static final Logger LOG = LoggerFactory.getLogger(JsRhinoScript.class);
  
  private final Context cx = Context.enter();
  
  private final ScriptableObject scope = this.cx.initStandardObjects();
  
  public JsRhinoScript() {
    try {
      try (InputStream scriptInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(
        "cool/taomu/framework/script/json2.min.js")) {
        ScriptableObject.putProperty(this.scope, "out", Context.javaToJS(System.out, this.scope));
        this.cx.evaluateString(this.scope, IOUtils.toString(scriptInput, "UTF-8"), null, 1, null);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public JsRhinoScript(final String path) {
    this();
    try {
      JsRhinoScript.LOG.info(String.format("加载脚本:%s", path));
      try (InputStream scriptInput2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(path)) {
        if ((scriptInput2 == null)) {
          try (FileInputStream scriptInput3 = new Function0<FileInputStream>() {
            @Override
            public FileInputStream apply() {
              try {
                File _file = new File(path);
                return new FileInputStream(_file);
              } catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
              }
            }
          }.apply()) {
            this.loaderScript(IOUtils.toString(scriptInput3, "UTF-8"));
          } catch (final Throwable _t) {
            if (_t instanceof FileNotFoundException) {
              final FileNotFoundException ex = (FileNotFoundException)_t;
              JsRhinoScript.LOG.info("", ex);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        } else {
          this.loaderScript(IOUtils.toString(scriptInput2, "UTF-8"));
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public <K extends Object, T extends Serializable> K invoke(final String name, final T value) {
    Object func = this.scope.get(name);
    if ((func instanceof Function)) {
      Function jfunc = ((Function)func);
      T inValue = SerializationUtils.<T>clone(value);
      Object _javaToJS = Context.javaToJS(inValue, this.scope);
      Object result = jfunc.call(this.cx, this.scope, this.scope, new Object[] { _javaToJS });
      K _xifexpression = null;
      if ((result != null)) {
        Object _jsToJava = Context.jsToJava(result, Object.class);
        _xifexpression = ((K) _jsToJava);
      }
      return _xifexpression;
    } else {
      JsRhinoScript.LOG.info(("unkown method : " + name));
      return null;
    }
  }
  
  @Override
  public void close() throws Exception {
    Context.exit();
  }
  
  @Override
  public void loaderScript(final String coding) {
    this.cx.evaluateString(this.scope, coding, null, 2, null);
  }
}
