/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.spi.annotation.Spi;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Spi(value = "mqtt_handler", svc = MQTTHandler.class)
@SuppressWarnings("all")
public class MQTTHandler extends ChannelInboundHandlerAdapter {
  private final Logger LOG = LoggerFactory.getLogger(MQTTHandler.class);
  
  @Spi(value = "mqtt_observable", singleton = true)
  private IObservable<?> observable;
  
  @Override
  public void channelRead(final ChannelHandlerContext ctx, final Object obj) {
    final MqttMessage mqttMessage = ((MqttMessage) obj);
    if (((mqttMessage != null) && mqttMessage.decoderResult().isSuccess())) {
      MqttMessageType messageType = mqttMessage.fixedHeader().messageType();
      final String typeName = messageType.name();
      this.LOG.debug("收到请求类型：{}", typeName);
      MqttDataEntity<MqttChannelEntity> data = new MqttDataEntity<MqttChannelEntity>();
      data.setDataType(MqttDataEntity.Type.valueOf(typeName));
      MqttChannelEntity _mqttChannelEntity = new MqttChannelEntity(ctx, mqttMessage);
      data.setData(_mqttChannelEntity);
      this.observable.publish(data);
    } else {
      ctx.close();
    }
  }
}
