package cool.taomu.framework.service.mqtt.broker.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class MqttDataEntity<T extends Object> {
  public enum Type {
    CONNECT,
    
    DISCONNECT,
    
    PINGREQ,
    
    PUBACK,
    
    PUBCOMP,
    
    PUBREC,
    
    PUBREL,
    
    SUBSCRIBE,
    
    UNSUBSCRIBE,
    
    PUBLISH;
  }
  
  private MqttDataEntity.Type dataType;
  
  private T data;
  
  @Pure
  public MqttDataEntity.Type getDataType() {
    return this.dataType;
  }
  
  public void setDataType(final MqttDataEntity.Type dataType) {
    this.dataType = dataType;
  }
  
  @Pure
  public T getData() {
    return this.data;
  }
  
  public void setData(final T data) {
    this.data = data;
  }
}
