/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.inter.cache.ICache;
import cool.taomu.framework.service.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.spi.annotation.Spi;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * DISCONNECT 	|	14 	|	两个方向都允许	|	断开连接通知
 */
@SuppressWarnings("all")
public class DisconnectRequest implements IObserver {
  private final Logger LOG = LoggerFactory.getLogger(DisconnectRequest.class);
  
  @Spi(value = "kvCache", singleton = true)
  private ICache<String, Serializable> cache;
  
  @Spi(value = "mqtt_pub_observable", singleton = true)
  private IObservable<IObserver> observable;
  
  public Object request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    this.LOG.info("执行了MQTT Disconnect 命令");
    String clientId = CommonUtils.getClientId(ctx.channel());
    Serializable _get = this.cache.get(CommonUtils.session(clientId));
    ClientSessionEntity clientSession = ((ClientSessionEntity) _get);
    this.pushWill(clientId);
    boolean _isCleanStatus = clientSession.isCleanStatus();
    if (_isCleanStatus) {
      this.cache.remove(CommonUtils.session(clientId));
    }
    ctx.close();
    return null;
  }
  
  public void pushWill(final String clientId) {
    Serializable _get = this.cache.get(CommonUtils.will(clientId));
    MessageEntity will = ((MessageEntity) _get);
    this.observable.publish(will);
  }
  
  @Override
  public void publish(final IObservable<?> o, final Object arg) {
    if ((arg instanceof MqttDataEntity)) {
      boolean _equals = ((MqttDataEntity)arg).getDataType().equals(MqttDataEntity.Type.DISCONNECT);
      if (_equals) {
        Object _data = ((MqttDataEntity)arg).getData();
        MqttChannelEntity mce = ((MqttChannelEntity) _data);
        this.request(mce.getCtx(), mce.getMessage());
      }
    }
  }
}
