/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * PINGREQ  V	|	12 	|	客户端到服务端 	|	心跳请求
 */
@SuppressWarnings("all")
public class PingEqRequest implements IObserver {
  private final Logger LOG = LoggerFactory.getLogger(PingEqRequest.class);
  
  public Object request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = CommonUtils.getClientId(ctx.channel());
    this.LOG.debug(("执行了MQTT PingEq 命令 : " + clientId));
    MqttFixedHeader mfh = new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0);
    MqttMessage mm = new MqttMessage(mfh);
    ctx.writeAndFlush(mm);
    return null;
  }
  
  @Override
  public void publish(final IObservable<?> o, final Object arg) {
    if ((arg instanceof MqttDataEntity)) {
      boolean _equals = ((MqttDataEntity)arg).getDataType().equals(MqttDataEntity.Type.PINGREQ);
      if (_equals) {
        Object _data = ((MqttDataEntity)arg).getData();
        MqttChannelEntity mce = ((MqttChannelEntity) _data);
        this.request(mce.getCtx(), mce.getMessage());
      }
    }
  }
}
