/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.inter.cache.ISetCache;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.spi.annotation.Spi;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * PUBCOMP  |   7   |   两个方向都允许     |   QoS 2 消息发布完成(保证交付第三步)
 */
@SuppressWarnings("all")
public class PubCompRequest implements IObserver {
  private final Logger LOG = LoggerFactory.getLogger(PubCompRequest.class);
  
  @Spi(value = "set_cache", singleton = true)
  private ISetCache<String, Serializable> cache;
  
  public Object request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = CommonUtils.getClientId(ctx.channel());
    this.LOG.info(("执行了MQTT PubComp 命令 : " + clientId));
    int msgId = CommonUtils.getMessageId(mqttMessage);
    String _qos2Message = CommonUtils.qos2Message(clientId);
    Set<Serializable> qos2 = this.cache.sget(IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(_qos2Message, Integer.valueOf(msgId))), "#"));
    for (final Serializable q : qos2) {
      {
        MessageEntity msg = ((MessageEntity) q);
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader _from = MqttMessageIdVariableHeader.from(msgId);
        MqttMessage _mqttMessage = new MqttMessage(header, _from);
        msg.getSenderChannel().writeAndFlush(_mqttMessage);
        String _qos2Message_1 = CommonUtils.qos2Message(clientId);
        this.cache.sremove(IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(_qos2Message_1, Integer.valueOf(msgId))), "#"), msg);
      }
    }
    return null;
  }
  
  @Override
  public void publish(final IObservable<?> o, final Object arg) {
    if ((arg instanceof MqttDataEntity)) {
      boolean _equals = ((MqttDataEntity)arg).getDataType().equals(MqttDataEntity.Type.PUBCOMP);
      if (_equals) {
        Object _data = ((MqttDataEntity)arg).getData();
        MqttChannelEntity mce = ((MqttChannelEntity) _data);
        this.request(mce.getCtx(), mce.getMessage());
      }
    }
  }
}
