/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.observer;

import cool.taomu.framework.impl.AObservable;
import cool.taomu.framework.inter.IBeanContainer;
import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.service.mqtt.broker.impl.ConnectRequest;
import cool.taomu.framework.service.mqtt.broker.impl.DisconnectRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PingEqRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubAckRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubCompRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubRecRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubRelRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PublishRequest;
import cool.taomu.framework.service.mqtt.broker.impl.SubscribeRequest;
import cool.taomu.framework.service.mqtt.broker.impl.UnSubscribeRequest;
import cool.taomu.framework.spi.annotation.Spi;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Spi(value = "mqtt_observable", svc = IObservable.class)
@SuppressWarnings("all")
public class MqttObservable extends AObservable<Class<? extends IObserver>> {
  private static final Logger LOG = LoggerFactory.getLogger(MqttObservable.class);
  
  @Spi(value = "TmBeanContainer", singleton = true)
  private IBeanContainer beanContainer;
  
  public MqttObservable() {
    this.register("CONNECT", ConnectRequest.class);
    this.register("DISCONNECT", DisconnectRequest.class);
    this.register("PINGREQ", PingEqRequest.class);
    this.register("PUBACK", PubAckRequest.class);
    this.register("PUBCOMP", PubCompRequest.class);
    this.register("PUBREC", PubRecRequest.class);
    this.register("PUBREL", PubRelRequest.class);
    this.register("SUBSCRIBE", SubscribeRequest.class);
    this.register("UNSUBSCRIBE", UnSubscribeRequest.class);
    this.register("PUBLISH", PublishRequest.class);
  }
  
  @Override
  public void publish(final Object arg, final Object... args) {
    MqttObservable.LOG.info("publish message");
    final Consumer<Class<? extends IObserver>> _function = (Class<? extends IObserver> it) -> {
      final Runnable _function_1 = () -> {
        synchronized (this.beanContainer) {
          String name = it.getName();
          MqttObservable.LOG.info("observer name {} args size {}", it.getName(), Integer.valueOf(args.length));
          Object _bean = this.beanContainer.getBean(name, args);
          IObserver instance = ((IObserver) _bean);
          MqttObservable.LOG.info("observer instance is null {}", Boolean.valueOf((instance == null)));
          instance.publish(this, arg);
        }
      };
      AObservable.exec.submit(_function_1);
    };
    this.providers.values().forEach(_function);
  }
}
