/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.inter.cache.ICache;
import cool.taomu.framework.service.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.PublishEntity;
import cool.taomu.framework.service.mqtt.broker.entity.TopicEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.service.utils.MessageTable;
import cool.taomu.framework.spi.annotation.Spi;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
public class Publish
implements IObserver {
    private final Logger LOG = LoggerFactory.getLogger(Publish.class);
    @Spi(value="kvCache", singleton=true)
    private ICache<String, Serializable> cache;
    private TopicEntity topic;
    private static AtomicInteger count = new AtomicInteger(0);
    private int number = 0;

    public Publish(TopicEntity topic) {
        this.topic = topic;
    }

    public Publish() {
        count.incrementAndGet();
        this.number = count.intValue();
    }

    private void publishMessage(MessageEntity msg) {
        try {
            Perl5Util p5 = new Perl5Util();
            String subTopicName = this.topic.getName().replace("/+", "/[a-zA-Z]?[a-zA-Z0-9]+").replace("/#", "/[a-zA-Z]?([a-zA-Z0-9/]*)").replace("/", "\\/");
            boolean _match = p5.match("/" + subTopicName + "/", msg.getTopic());
            if (_match) {
                this.LOG.info("\u53d1\u9001\u8005id : {},  Topic : {}", (Object)msg.getSenderId(), (Object)msg.getTopic());
                int minQos = CommonUtils.getQos(msg.getQos(), this.topic.getQos());
                if (minQos == 2) {
                    MessageEntity cloneMsg = (MessageEntity)SerializationUtils.clone((Serializable)msg);
                    cloneMsg.setSenderChannel(msg.getSenderChannel());
                    this.cache.put((Object)CommonUtils.qos2Message(this.topic.getClientId()), (Object)cloneMsg);
                }
                Serializable _get = (Serializable)this.cache.get((Object)CommonUtils.session(this.topic.getClientId()));
                ClientSessionEntity clientSession = (ClientSessionEntity)_get;
                int _generateMessageId = clientSession.generateMessageId();
                Integer msgId = _generateMessageId;
                this.LOG.info("\u8ba2\u9605\u8005id : {},  Topic : {}, \u53d1\u9001\u5185\u5bb9\u957f\u5ea6\uff1a {} messageId : {}", new Object[]{this.topic.getClientId(), this.topic.getName(), msg.getPayload().length, msgId});
                MessageTable.table.put((Object)this.topic.getClientId(), (Object)msgId, (Object)msg);
                MqttQoS _valueOf = MqttQoS.valueOf((int)minQos);
                String _name = this.topic.getName();
                byte[] _payload = msg.getPayload();
                PublishEntity entity = new PublishEntity(_valueOf, _name, msgId, _payload, false);
                clientSession.getCtx().writeAndFlush((Object)this.response(entity));
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                this.LOG.debug("publishMessage \u65b9\u6cd5\u51fa\u73b0\u9519\u8bef : ", (Throwable)ex);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private MqttPublishMessage response(PublishEntity entity) {
        boolean _tripleEquals;
        this.LOG.debug("------<>{}", (Object)entity.getMessageId());
        Boolean _dup = entity.getDup();
        MqttQoS _qos = entity.getQos();
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBLISH, _dup.booleanValue(), _qos, false, 0);
        String _topicName = entity.getTopicName();
        Integer _messageId = entity.getMessageId();
        MqttPublishVariableHeader varHeader = new MqttPublishVariableHeader(_topicName, _messageId.intValue());
        ByteBuf heapBuf = null;
        byte[] _payload = entity.getPayload();
        boolean bl = _tripleEquals = _payload == null;
        if (_tripleEquals) {
            heapBuf = Unpooled.EMPTY_BUFFER;
        } else {
            try {
                heapBuf = Unpooled.wrappedBuffer((byte[])entity.getPayload());
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    IllegalArgumentException e = (IllegalArgumentException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return new MqttPublishMessage(header, varHeader, heapBuf);
    }

    public void publish(IObservable<?> o, Object arg) {
        if (arg instanceof MessageEntity) {
            this.publishMessage((MessageEntity)arg);
        }
    }

    @Pure
    public Logger getLOG() {
        return this.LOG;
    }

    @Pure
    public ICache<String, Serializable> getCache() {
        return this.cache;
    }

    public void setCache(ICache<String, Serializable> cache) {
        this.cache = cache;
    }

    @Pure
    public TopicEntity getTopic() {
        return this.topic;
    }

    public void setTopic(TopicEntity topic) {
        this.topic = topic;
    }

    @Pure
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }
}

