/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.entity;

import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@EqualsHashCode
public class ClientSessionEntity
implements Serializable {
    private String clientId;
    private boolean cleanStatus;
    private transient ChannelHandlerContext ctx;
    private transient AtomicInteger messageIdCounter = new AtomicInteger(1);

    public int generateMessageId() {
        int messageId = this.messageIdCounter.getAndIncrement();
        if ((messageId = Math.abs(messageId % 65535)) == 0) {
            return this.generateMessageId();
        }
        return messageId;
    }

    @Pure
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Pure
    public boolean isCleanStatus() {
        return this.cleanStatus;
    }

    public void setCleanStatus(boolean cleanStatus) {
        this.cleanStatus = cleanStatus;
    }

    @Pure
    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Pure
    public AtomicInteger getMessageIdCounter() {
        return this.messageIdCounter;
    }

    public void setMessageIdCounter(AtomicInteger messageIdCounter) {
        this.messageIdCounter = messageIdCounter;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("clientId", (Object)this.clientId);
        b.add("cleanStatus", (Object)this.cleanStatus);
        return b.toString();
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientSessionEntity other = (ClientSessionEntity)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        return other.cleanStatus == this.cleanStatus;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        return 31 * result + (this.cleanStatus ? 1231 : 1237);
    }
}

