/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.service.utils.MessageTable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubAckRequest
implements IObserver {
    private final Logger LOG = LoggerFactory.getLogger(PubAckRequest.class);

    public Object request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        String clientId = CommonUtils.getClientId(ctx.channel());
        if (clientId == null) {
            clientId = CommonUtils.getClientId(ctx.channel());
        }
        MqttPubAckMessage puback = (MqttPubAckMessage)mqttMessage;
        int msgId = puback.variableHeader().messageId();
        MessageTable.table.remove((Object)clientId, (Object)msgId);
        this.LOG.info("\u6267\u884c\u4e86MQTT PubAck \u547d\u4ee4 clientId : {} messageId : {}", (Object)clientId, (Object)msgId);
        return null;
    }

    public void publish(IObservable<?> o, Object arg) {
        boolean _equals;
        if (arg instanceof MqttDataEntity && (_equals = ((MqttDataEntity)arg).getDataType().equals((Object)MqttDataEntity.Type.PUBACK))) {
            Object _data = ((MqttDataEntity)arg).getData();
            MqttChannelEntity mce = (MqttChannelEntity)_data;
            this.request(mce.getCtx(), mce.getMessage());
        }
    }
}

