/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.spi.annotation.Spi;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Spi(value="mqtt_handler", svc=MQTTHandler.class)
public class MQTTHandler
extends ChannelInboundHandlerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(MQTTHandler.class);
    @Spi(value="mqtt_observable", singleton=true)
    private IObservable<?> observable;

    public void channelRead(ChannelHandlerContext ctx, Object obj) {
        MqttMessage mqttMessage = (MqttMessage)obj;
        if (mqttMessage != null && mqttMessage.decoderResult().isSuccess()) {
            MqttMessageType messageType = mqttMessage.fixedHeader().messageType();
            String typeName = messageType.name();
            this.LOG.debug("\u6536\u5230\u8bf7\u6c42\u7c7b\u578b\uff1a{}", (Object)typeName);
            MqttDataEntity<MqttChannelEntity> data = new MqttDataEntity<MqttChannelEntity>();
            data.setDataType(MqttDataEntity.Type.valueOf(typeName));
            MqttChannelEntity _mqttChannelEntity = new MqttChannelEntity(ctx, mqttMessage);
            data.setData(_mqttChannelEntity);
            this.observable.publish(data, new Object[0]);
        } else {
            ctx.close();
        }
    }
}

