/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.inter.IConfigureManage;
import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.inter.cache.ICache;
import cool.taomu.framework.service.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.framework.service.mqtt.broker.entity.ConnackEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.spi.annotation.Spi;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.Serializable;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectRequest
implements IObserver {
    private Logger LOG = LoggerFactory.getLogger(ConnectRequest.class);
    @Spi(value="kvCache", singleton=true)
    private ICache<String, Serializable> cache;
    @Spi(value="taomu-configure", singleton=true)
    private IConfigureManage<ConfigureEntity> config;
    protected ChannelHandlerContext ctx;
    protected MqttMessage message;

    public boolean checkVersion(int mqttVersion) {
        switch (mqttVersion) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean checkClientId(String clientId) {
        boolean _equals = CommonUtils.getClientId(this.ctx.channel()).equals(clientId);
        return _equals;
    }

    public boolean checkAuthorized(String addr, String clientId) {
        return true;
    }

    public boolean checkUserAuth(String clientId, String userName, byte[] password) {
        ConfigureEntity config = (ConfigureEntity)this.config.loadConfig();
        boolean _isAnonymous = config.getMqtt().isAnonymous();
        if (_isAnonymous) {
            return true;
        }
        return userName.equals(config.getMqtt().getUsername()) && config.getMqtt().getPassword().equals(new String(password));
    }

    public boolean keepAlive(String clientId, ChannelHandlerContext ctx, int heatbeatSec) {
        this.LOG.info("\u8bbe\u7f6ekeep alive");
        int keepAlive = (int)((float)heatbeatSec * 1.5f);
        boolean _contains = ctx.pipeline().names().contains("idleStateHandler");
        if (_contains) {
            ctx.pipeline().remove("idleStateHandler");
        }
        ChannelPipeline _pipeline = ctx.pipeline();
        IdleStateHandler _idleStateHandler = new IdleStateHandler(keepAlive, 0, 0);
        _pipeline.addFirst("idleStateHandler", (ChannelHandler)_idleStateHandler);
        return true;
    }

    public Object request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        if (!(mqttMessage instanceof MqttConnectMessage)) {
            return null;
        }
        this.LOG.info("\u6267\u884c Connect \u64cd\u4f5c");
        ConnackEntity entity = null;
        boolean sessionPresent = false;
        try {
            boolean _not;
            MqttConnectMessage connect = (MqttConnectMessage)mqttMessage;
            int version = connect.variableHeader().version();
            this.LOG.info("mqtt version:{}", (Object)version);
            boolean isCleanSession = connect.variableHeader().isCleanSession();
            String clientId = connect.payload().clientIdentifier();
            CommonUtils.setClientId(ctx.channel(), clientId);
            String uname = connect.payload().userName();
            byte[] passwd = connect.payload().passwordInBytes();
            int heartbeatSec = connect.variableHeader().keepAliveTimeSeconds();
            this.LOG.info("clientId:{},cleanSession:{}", (Object)clientId, (Object)isCleanSession);
            boolean _checkVersion = this.checkVersion(version);
            boolean bl = _not = !_checkVersion;
            if (_not) {
                ConnackEntity _connackEntity;
                entity = _connackEntity = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION, sessionPresent);
            } else {
                boolean _not_1;
                boolean _checkClientId = this.checkClientId(clientId);
                boolean bl2 = _not_1 = !_checkClientId;
                if (_not_1) {
                    ConnackEntity _connackEntity_1;
                    entity = _connackEntity_1 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED, sessionPresent);
                } else {
                    boolean _not_2;
                    boolean _checkAuthorized = this.checkAuthorized(CommonUtils.getRemoteAddr(ctx.channel()), clientId);
                    boolean bl3 = _not_2 = !_checkAuthorized;
                    if (_not_2) {
                        ConnackEntity _connackEntity_2;
                        entity = _connackEntity_2 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED, sessionPresent);
                    } else {
                        boolean _not_3;
                        boolean _checkUserAuth = this.checkUserAuth(clientId, uname, passwd);
                        boolean bl4 = _not_3 = !_checkUserAuth;
                        if (_not_3) {
                            ConnackEntity _connackEntity_3;
                            entity = _connackEntity_3 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD, sessionPresent);
                        } else {
                            ConnackEntity _connackEntity_4;
                            boolean _not_4;
                            boolean _keepAlive = this.keepAlive(clientId, ctx, heartbeatSec);
                            boolean bl5 = _not_4 = !_keepAlive;
                            if (_not_4) {
                                String failure = String.format("set heartbeat failure clientId:%s,heartbeatSec:%d", clientId, heartbeatSec);
                                throw new Exception(failure);
                            }
                            sessionPresent = this.createSession(clientId, ctx, isCleanSession);
                            this.storeWill(connect, clientId);
                            entity = _connackEntity_4 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_ACCEPTED, sessionPresent);
                        }
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                ConnackEntity _connackEntity_5;
                Exception ex = (Exception)_t;
                this.LOG.info("Service Unavailable:", (Throwable)ex);
                entity = _connackEntity_5 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE, sessionPresent);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        this.LOG.info("\u6267\u884c\u4e86MQTT Connack \u547d\u4ee4");
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.CONNACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttConnectReturnCode _code = entity.getCode();
        boolean _isSessionPresent = entity.isSessionPresent();
        MqttConnAckVariableHeader varHeader = new MqttConnAckVariableHeader(_code, _isSessionPresent);
        MqttConnAckMessage _mqttConnAckMessage = new MqttConnAckMessage(header, varHeader);
        ctx.writeAndFlush((Object)_mqttConnAckMessage);
        return null;
    }

    protected void storeWill(MqttConnectMessage connectMessage, String clientId) {
        boolean _isWillFlag = connectMessage.variableHeader().isWillFlag();
        if (_isWillFlag) {
            this.LOG.info("\u4fdd\u5b58Will\u6d88\u606f \uff1a clientId:{}", (Object)clientId);
            MessageEntity will = new MessageEntity();
            will.setSenderId(clientId);
            will.setRetain(connectMessage.variableHeader().isWillRetain());
            will.setQos(connectMessage.variableHeader().willQos());
            will.setTopic(connectMessage.payload().willTopic());
            will.setPayload(connectMessage.payload().willMessageInBytes());
            this.cache.put((Object)CommonUtils.will(clientId), (Object)will);
        }
    }

    protected Boolean createSession(String clientId, ChannelHandlerContext ctx, boolean cleanSession) {
        ClientSessionEntity _clientSessionEntity;
        this.LOG.info("\u8bb0\u5f55\u7528\u6237session\uff1a{}", (Object)clientId);
        ClientSessionEntity mqttSession = new ClientSessionEntity();
        boolean sessionPresent = false;
        mqttSession = _clientSessionEntity = new ClientSessionEntity();
        mqttSession.setClientId(clientId);
        mqttSession.setCtx(ctx);
        mqttSession.setCleanStatus(cleanSession);
        if (!cleanSession) {
            sessionPresent = true;
        }
        this.cache.put((Object)CommonUtils.session(clientId), (Object)mqttSession);
        return sessionPresent;
    }

    public void publish(IObservable<?> o, Object arg) {
        boolean _equals;
        if (arg instanceof MqttDataEntity && (_equals = ((MqttDataEntity)arg).getDataType().equals((Object)MqttDataEntity.Type.CONNECT))) {
            Object _data = ((MqttDataEntity)arg).getData();
            MqttChannelEntity mce = (MqttChannelEntity)_data;
            this.ctx = mce.getCtx();
            this.message = mce.getMessage();
            this.request(this.ctx, this.message);
        }
    }
}

