/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.inter.cache.ICache;
import cool.taomu.framework.service.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.spi.annotation.Spi;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectRequest
implements IObserver {
    private final Logger LOG = LoggerFactory.getLogger(DisconnectRequest.class);
    @Spi(value="kvCache", singleton=true)
    private ICache<String, Serializable> cache;
    @Spi(value="mqtt_pub_observable", singleton=true)
    private IObservable<IObserver> observable;

    public Object request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        this.LOG.info("\u6267\u884c\u4e86MQTT Disconnect \u547d\u4ee4");
        String clientId = CommonUtils.getClientId(ctx.channel());
        Serializable _get = (Serializable)this.cache.get((Object)CommonUtils.session(clientId));
        ClientSessionEntity clientSession = (ClientSessionEntity)_get;
        this.pushWill(clientId);
        boolean _isCleanStatus = clientSession.isCleanStatus();
        if (_isCleanStatus) {
            this.cache.remove((Object)CommonUtils.session(clientId));
        }
        ctx.close();
        return null;
    }

    public void pushWill(String clientId) {
        Serializable _get = (Serializable)this.cache.get((Object)CommonUtils.will(clientId));
        MessageEntity will = (MessageEntity)_get;
        this.observable.publish((Object)will, new Object[0]);
    }

    public void publish(IObservable<?> o, Object arg) {
        boolean _equals;
        if (arg instanceof MqttDataEntity && (_equals = ((MqttDataEntity)arg).getDataType().equals((Object)MqttDataEntity.Type.DISCONNECT))) {
            Object _data = ((MqttDataEntity)arg).getData();
            MqttChannelEntity mce = (MqttChannelEntity)_data;
            this.request(mce.getCtx(), mce.getMessage());
        }
    }
}

