/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.service.mqtt.broker.entity.MqttChannelEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MqttDataEntity;
import cool.taomu.framework.service.utils.CommonUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingEqRequest
implements IObserver {
    private final Logger LOG = LoggerFactory.getLogger(PingEqRequest.class);

    public Object request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        String clientId = CommonUtils.getClientId(ctx.channel());
        this.LOG.debug("\u6267\u884c\u4e86MQTT PingEq \u547d\u4ee4 : " + clientId);
        MqttFixedHeader mfh = new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessage mm = new MqttMessage(mfh);
        ctx.writeAndFlush((Object)mm);
        return null;
    }

    public void publish(IObservable<?> o, Object arg) {
        boolean _equals;
        if (arg instanceof MqttDataEntity && (_equals = ((MqttDataEntity)arg).getDataType().equals((Object)MqttDataEntity.Type.PINGREQ))) {
            Object _data = ((MqttDataEntity)arg).getData();
            MqttChannelEntity mce = (MqttChannelEntity)_data;
            this.request(mce.getCtx(), mce.getMessage());
        }
    }
}

