/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.observer;

import cool.taomu.framework.impl.AObservable;
import cool.taomu.framework.inter.IBeanContainer;
import cool.taomu.framework.inter.IObservable;
import cool.taomu.framework.inter.IObserver;
import cool.taomu.framework.service.mqtt.broker.impl.ConnectRequest;
import cool.taomu.framework.service.mqtt.broker.impl.DisconnectRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PingEqRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubAckRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubCompRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubRecRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PubRelRequest;
import cool.taomu.framework.service.mqtt.broker.impl.PublishRequest;
import cool.taomu.framework.service.mqtt.broker.impl.SubscribeRequest;
import cool.taomu.framework.service.mqtt.broker.impl.UnSubscribeRequest;
import cool.taomu.framework.spi.annotation.Spi;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Spi(value="mqtt_observable", svc=IObservable.class)
public class MqttObservable
extends AObservable<Class<? extends IObserver>> {
    private static final Logger LOG = LoggerFactory.getLogger(MqttObservable.class);
    @Spi(value="TmBeanContainer", singleton=true)
    private IBeanContainer beanContainer;

    public MqttObservable() {
        this.register("CONNECT", ConnectRequest.class);
        this.register("DISCONNECT", DisconnectRequest.class);
        this.register("PINGREQ", PingEqRequest.class);
        this.register("PUBACK", PubAckRequest.class);
        this.register("PUBCOMP", PubCompRequest.class);
        this.register("PUBREC", PubRecRequest.class);
        this.register("PUBREL", PubRelRequest.class);
        this.register("SUBSCRIBE", SubscribeRequest.class);
        this.register("UNSUBSCRIBE", UnSubscribeRequest.class);
        this.register("PUBLISH", PublishRequest.class);
    }

    public void publish(Object arg, Object ... args) {
        LOG.info("publish message");
        Consumer<Class> _function = it -> {
            Runnable _function_1 = () -> {
                IBeanContainer iBeanContainer = this.beanContainer;
                synchronized (iBeanContainer) {
                    String name = it.getName();
                    LOG.info("observer name {} args size {}", (Object)it.getName(), (Object)args.length);
                    Object _bean = this.beanContainer.getBean(name, args);
                    IObserver instance = (IObserver)_bean;
                    LOG.info("observer instance is null {}", (Object)(instance == null ? 1 : 0));
                    instance.publish((IObservable)this, arg);
                }
            };
            AObservable.exec.submit(_function_1);
        };
        this.providers.values().forEach(_function);
    }
}

