package cool.taomu.framework.demo;

import cool.taomu.framework.client.mqtt.MqttCallback;
import cool.taomu.framework.client.mqtt.annotation.Topic;
import cool.taomu.framework.client.mqtt.annotation.Will;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Topic(value = { "topic_a1", "topic_a2" })
@Will(message = "mqttDemo discation", topic = "client/error")
@SuppressWarnings("all")
public class MqttDemo extends MqttCallback {
  private static final Logger LOG = LoggerFactory.getLogger(MqttDemo.class);
  
  @Autowired
  private ITSpring tSpring;
  
  @Override
  public void messageArrived(final String topic, final MqttMessage message) throws Exception {
    byte[] _base64 = this.tSpring.getBase64(message.getPayload());
    String _string = new String(_base64, "UTF-8");
    MqttDemo.LOG.info(_string);
  }
}
