package cool.taomu.framework.demo;

import cool.taomu.framework.client.mqtt.Subscriber;
import cool.taomu.framework.inter.ISpringPlugin;
import cool.taomu.framework.spi.TmServiceLoader;
import cool.taomu.framework.utils.reflect.ReflectUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages = { "cool.taomu.framework.demo" })
@SuppressWarnings("all")
public class CreateMqttClient {
  public static void main(final String[] args) {
    ConfigurableApplicationContext app = SpringApplication.run(CreateMqttClient.class, args);
    TmServiceLoader sl = new TmServiceLoader();
    Class<?> spi = sl.getBean(ISpringPlugin.class, 0);
    Object _newInstance = ReflectUtils.newInstance(spi, app);
    ISpringPlugin instance = ((ISpringPlugin) _newInstance);
    Subscriber sub = new Subscriber("0.0.0.0", 1883, "admin", "123456");
    sub.subscriber(instance, MqttDemo.class);
  }
}
