/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.spring.plugin;

import cool.taomu.framework.inter.ISpringPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class TaomuSpringPlugin
implements ISpringPlugin {
    private final Logger LOG = LoggerFactory.getLogger(TaomuSpringPlugin.class);
    private ApplicationContext applicationContext;

    public TaomuSpringPlugin(GenericApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object getBeanObject(Class<?> zlass) {
        this.LOG.info(zlass.getName());
        this.register(zlass.getName(), zlass);
        return this.applicationContext.getBean(zlass.getName());
    }

    public void register(String key, Class<?> zlass) {
        BeanDefinitionBuilder bean = BeanDefinitionBuilder.genericBeanDefinition(zlass);
        ConfigurableApplicationContext config = (ConfigurableApplicationContext)this.applicationContext;
        ConfigurableListableBeanFactory _beanFactory = config.getBeanFactory();
        DefaultListableBeanFactory registry = (DefaultListableBeanFactory)_beanFactory;
        registry.setAllowBeanDefinitionOverriding(true);
        boolean _containsBeanDefinition = registry.containsBeanDefinition(key);
        if (_containsBeanDefinition) {
            registry.removeBeanDefinition(key);
        }
        registry.registerBeanDefinition(key, (BeanDefinition)bean.getRawBeanDefinition());
    }
}

