/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.objectpool;

import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class ObjectPool<T extends Object> implements AutoCloseable {
  private int id;
  
  private T instance;
  
  private GenericKeyedObjectPool<Class<T>, ObjectPool<T>> opf;
  
  public ObjectPool(final GenericKeyedObjectPool<Class<T>, ObjectPool<T>> opf, final T instance, final int id) {
    this.instance = instance;
    this.id = id;
    this.opf = opf;
  }
  
  @Override
  public void close() throws Exception {
    Class<?> _class = this.instance.getClass();
    this.opf.returnObject(((Class<T>) _class), this);
  }
  
  @Pure
  public int getId() {
    return this.id;
  }
  
  public void setId(final int id) {
    this.id = id;
  }
  
  @Pure
  public T getInstance() {
    return this.instance;
  }
  
  public void setInstance(final T instance) {
    this.instance = instance;
  }
  
  @Pure
  public GenericKeyedObjectPool<Class<T>, ObjectPool<T>> getOpf() {
    return this.opf;
  }
  
  public void setOpf(final GenericKeyedObjectPool<Class<T>, ObjectPool<T>> opf) {
    this.opf = opf;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("id", this.id);
    b.add("instance", this.instance);
    b.add("opf", this.opf);
    return b.toString();
  }
}
