/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@SuppressWarnings("all")
public class CreateTempFile {
  public static File create(final byte[] content, final String charset) {
    Charset _forName = Charset.forName(charset);
    String _string = new String(content, _forName);
    return CreateTempFile.create(_string);
  }
  
  public static File create(final String content) {
    try {
      String tempName = UUID.randomUUID().toString();
      File temp = File.createTempFile(tempName, ".temp");
      temp.deleteOnExit();
      try (BufferedWriter bw = new Function0<BufferedWriter>() {
        @Override
        public BufferedWriter apply() {
          try {
            FileWriter _fileWriter = new FileWriter(temp);
            return new BufferedWriter(_fileWriter);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        bw.write(content);
      }
      return temp;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static File create(final byte[] content) {
    try {
      String tempName = UUID.randomUUID().toString();
      File temp = File.createTempFile(tempName, ".temp");
      temp.deleteOnExit();
      FileUtils.writeByteArrayToFile(temp, content);
      return temp;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
