/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.configure;

import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.configure.entity.MqttEntity;
import cool.taomu.framework.configure.entity.ObjectPoolEntity;
import cool.taomu.framework.configure.entity.RpcEntity;
import cool.taomu.framework.inter.IConfigureManage;
import cool.taomu.framework.spi.annotation.Spi;
import java.io.FileReader;
import java.net.URL;
import org.apache.commons.lang3.Validate;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.yaml.snakeyaml.Yaml;

@Spi(value = "taomu-configure", singleton = true)
@SuppressWarnings("all")
public class ConfigureManage implements IConfigureManage<ConfigureEntity> {
  private String configPath = "taomu.yml";
  
  @Override
  public ConfigureEntity loadConfig() {
    try {
      Validate.<String>notBlank(this.configPath, "configure path 不能为空");
      URL url = Thread.currentThread().getContextClassLoader().getResource(this.configPath);
      if ((url == null)) {
        URL _uRL = new URL(("file://" + this.configPath));
        url = _uRL;
      }
      ConfigureEntity config = new ConfigureEntity();
      Yaml _yaml = new Yaml();
      String _path = url.getPath();
      FileReader _fileReader = new FileReader(_path);
      config = _yaml.<ConfigureEntity>loadAs(_fileReader, ConfigureEntity.class);
      MqttEntity _mqtt = config.getMqtt();
      boolean _tripleEquals = (_mqtt == null);
      if (_tripleEquals) {
        MqttEntity _mqttEntity = new MqttEntity();
        config.setMqtt(_mqttEntity);
      }
      RpcEntity _rpc = config.getRpc();
      boolean _tripleEquals_1 = (_rpc == null);
      if (_tripleEquals_1) {
        RpcEntity _rpcEntity = new RpcEntity();
        config.setRpc(_rpcEntity);
      }
      ObjectPoolEntity _pool = config.getPool();
      boolean _tripleEquals_2 = (_pool == null);
      if (_tripleEquals_2) {
        ObjectPoolEntity _objectPoolEntity = new ObjectPoolEntity();
        config.setPool(_objectPoolEntity);
      }
      return config;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public void setConfigPath(final String path) {
    this.configPath = path;
  }
}
