/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.configure.entity;

import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class JeidsConfigEntity {
  private List<HostEntity> cluster;
  
  private String username;
  
  private String password;
  
  private Integer maxIdle;
  
  private Integer minIdle;
  
  private Integer maxTotal;
  
  private Integer timeout = Integer.valueOf(5000);
  
  private Integer maxAttempts = Integer.valueOf(5);
  
  private boolean testOnBorrow = true;
  
  private boolean testOnReturn = false;
  
  private boolean isClustered = false;
  
  @Pure
  public List<HostEntity> getCluster() {
    return this.cluster;
  }
  
  public void setCluster(final List<HostEntity> cluster) {
    this.cluster = cluster;
  }
  
  @Pure
  public String getUsername() {
    return this.username;
  }
  
  public void setUsername(final String username) {
    this.username = username;
  }
  
  @Pure
  public String getPassword() {
    return this.password;
  }
  
  public void setPassword(final String password) {
    this.password = password;
  }
  
  @Pure
  public Integer getMaxIdle() {
    return this.maxIdle;
  }
  
  public void setMaxIdle(final Integer maxIdle) {
    this.maxIdle = maxIdle;
  }
  
  @Pure
  public Integer getMinIdle() {
    return this.minIdle;
  }
  
  public void setMinIdle(final Integer minIdle) {
    this.minIdle = minIdle;
  }
  
  @Pure
  public Integer getMaxTotal() {
    return this.maxTotal;
  }
  
  public void setMaxTotal(final Integer maxTotal) {
    this.maxTotal = maxTotal;
  }
  
  @Pure
  public Integer getTimeout() {
    return this.timeout;
  }
  
  public void setTimeout(final Integer timeout) {
    this.timeout = timeout;
  }
  
  @Pure
  public Integer getMaxAttempts() {
    return this.maxAttempts;
  }
  
  public void setMaxAttempts(final Integer maxAttempts) {
    this.maxAttempts = maxAttempts;
  }
  
  @Pure
  public boolean isTestOnBorrow() {
    return this.testOnBorrow;
  }
  
  public void setTestOnBorrow(final boolean testOnBorrow) {
    this.testOnBorrow = testOnBorrow;
  }
  
  @Pure
  public boolean isTestOnReturn() {
    return this.testOnReturn;
  }
  
  public void setTestOnReturn(final boolean testOnReturn) {
    this.testOnReturn = testOnReturn;
  }
  
  @Pure
  public boolean isClustered() {
    return this.isClustered;
  }
  
  public void setIsClustered(final boolean isClustered) {
    this.isClustered = isClustered;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("cluster", this.cluster);
    b.add("username", this.username);
    b.add("password", this.password);
    b.add("maxIdle", this.maxIdle);
    b.add("minIdle", this.minIdle);
    b.add("maxTotal", this.maxTotal);
    b.add("timeout", this.timeout);
    b.add("maxAttempts", this.maxAttempts);
    b.add("testOnBorrow", this.testOnBorrow);
    b.add("testOnReturn", this.testOnReturn);
    b.add("isClustered", this.isClustered);
    return b.toString();
  }
}
