/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.configure.entity;

import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class MqttEntity {
  private boolean anonymous = true;
  
  private String username;
  
  private String password;
  
  private String hostname = "0.0.0.0";
  
  private Integer port = Integer.valueOf(1883);
  
  private boolean useSsl = false;
  
  private SslEntity ssl;
  
  private List<ClusterEntity> cluster;
  
  @Pure
  public boolean isAnonymous() {
    return this.anonymous;
  }
  
  public void setAnonymous(final boolean anonymous) {
    this.anonymous = anonymous;
  }
  
  @Pure
  public String getUsername() {
    return this.username;
  }
  
  public void setUsername(final String username) {
    this.username = username;
  }
  
  @Pure
  public String getPassword() {
    return this.password;
  }
  
  public void setPassword(final String password) {
    this.password = password;
  }
  
  @Pure
  public String getHostname() {
    return this.hostname;
  }
  
  public void setHostname(final String hostname) {
    this.hostname = hostname;
  }
  
  @Pure
  public Integer getPort() {
    return this.port;
  }
  
  public void setPort(final Integer port) {
    this.port = port;
  }
  
  @Pure
  public boolean isUseSsl() {
    return this.useSsl;
  }
  
  public void setUseSsl(final boolean useSsl) {
    this.useSsl = useSsl;
  }
  
  @Pure
  public SslEntity getSsl() {
    return this.ssl;
  }
  
  public void setSsl(final SslEntity ssl) {
    this.ssl = ssl;
  }
  
  @Pure
  public List<ClusterEntity> getCluster() {
    return this.cluster;
  }
  
  public void setCluster(final List<ClusterEntity> cluster) {
    this.cluster = cluster;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("anonymous", this.anonymous);
    b.add("username", this.username);
    b.add("password", this.password);
    b.add("hostname", this.hostname);
    b.add("port", this.port);
    b.add("useSsl", this.useSsl);
    b.add("ssl", this.ssl);
    b.add("cluster", this.cluster);
    return b.toString();
  }
}
