/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class GzipUtils {
  public static byte[] zip(final byte[] arg) {
    try {
      byte[] result = new byte[0];
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      try (GZIPOutputStream gzipos = new Function0<GZIPOutputStream>() {
        @Override
        public GZIPOutputStream apply() {
          try {
            return new GZIPOutputStream(baos);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        gzipos.write(arg);
        gzipos.finish();
        result = baos.toByteArray();
      } finally {
        if ((baos != null)) {
          baos.close();
        }
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static byte[] unzip(final byte[] arg) {
    try {
      byte[] result = new byte[0];
      ByteArrayInputStream bais = new ByteArrayInputStream(arg);
      try (GZIPInputStream gzip = new Function0<GZIPInputStream>() {
        @Override
        public GZIPInputStream apply() {
          try {
            return new GZIPInputStream(bais);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        result = IOUtils.toByteArray(gzip);
      } finally {
        if ((bais != null)) {
          bais.close();
        }
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void main(final String[] arg) {
    String a = "Hello";
    byte[] r = GzipUtils.zip(a.getBytes());
    byte[] rr = GzipUtils.unzip(r);
    String _string = new String(rr);
    InputOutput.<String>println(_string);
  }
}
