/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils.crypto;

import cool.taomu.framework.crypto.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.util.io.Streams;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PgpUtils.class);

    public static void main(String[] args) {
        try {
            BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider((Provider)_bouncyCastleProvider);
            File _file = new File("src/test/resources/publicKey1.txt");
            String pk = FileUtils.readFileToString((File)_file, (Charset)Charset.forName("UTF-8"));
            byte[] data = PgpUtils.encrypt("Hello World!!!! ".getBytes(), pk, true);
            String _string = new String(data, "UTF-8");
            InputOutput.println((Object)_string);
            File _file_1 = new File("src/test/resources/privateKey1.txt");
            String prk = FileUtils.readFileToString((File)_file_1, (Charset)Charset.forName("UTF-8"));
            byte[] d = PgpUtils.decrypt(data, prk, "123456789");
            String _string_1 = new String(d, "UTF-8");
            String _plus = "result : " + _string_1;
            InputOutput.println((Object)_plus);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decrypt(byte[] data, String privateKey, String password) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            byte[] byArray;
            InputStream input = PGPUtil.getDecoderStream((InputStream)bais);
            JcaPGPObjectFactory jpof = new JcaPGPObjectFactory(input);
            Object o = jpof.nextObject();
            PGPEncryptedDataList enc = null;
            if (o instanceof PGPEncryptedDataList) {
                enc = (PGPEncryptedDataList)o;
            } else {
                Object _nextObject = jpof.nextObject();
                enc = (PGPEncryptedDataList)_nextObject;
            }
            byte[] _bytes = privateKey.getBytes();
            byte[] pkeyBase64 = new Base64(_bytes).decode();
            JcaKeyFingerprintCalculator _jcaKeyFingerprintCalculator = new JcaKeyFingerprintCalculator();
            PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(pkeyBase64, (KeyFingerPrintCalculator)_jcaKeyFingerprintCalculator);
            Iterator edo = enc.getEncryptedDataObjects();
            Functions.Function1 _function = k -> {
                try {
                    PGPSecretKey _secretKey = pgpSec.getSecretKey(((PGPPublicKeyEncryptedData)k).getKeyID());
                    return _secretKey != null;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            PGPEncryptedData _findFirst = (PGPEncryptedData)IteratorExtensions.findFirst((Iterator)edo, (Functions.Function1)_function);
            PGPPublicKeyEncryptedData pbe = (PGPPublicKeyEncryptedData)_findFirst;
            PGPSecretKey secKey = pgpSec.getSecretKey(pbe.getKeyID());
            PBESecretKeyDecryptor jpekdb = new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(password.toCharArray());
            PGPPrivateKey sKey = secKey.extractPrivateKey(jpekdb);
            InputStream clear = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(sKey));
            JcaPGPObjectFactory plain = new JcaPGPObjectFactory(clear);
            Object message = plain.nextObject();
            if (input != null) {
                input.close();
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                if (message instanceof PGPCompressedData) {
                    InputStream _dataStream = ((PGPCompressedData)message).getDataStream();
                    JcaPGPObjectFactory fact = new JcaPGPObjectFactory(_dataStream);
                    message = fact.nextObject();
                }
                if (message instanceof PGPLiteralData) {
                    Streams.pipeAll((InputStream)((PGPLiteralData)message).getInputStream(), (OutputStream)out);
                } else if (message instanceof PGPOnePassSignatureList) {
                    LOG.info("encrypted message contains a signed message - not literal data.");
                } else if (message instanceof PGPSignatureList) {
                    LOG.info("encrypted message contains a signed message - not literal data.");
                }
                boolean _isIntegrityProtected = pbe.isIntegrityProtected();
                if (_isIntegrityProtected) {
                    boolean _not;
                    boolean _verify = pbe.verify();
                    boolean bl = _not = !_verify;
                    if (_not) {
                        LOG.info("message failed integrity check");
                    } else {
                        LOG.info("message integrity check passed");
                    }
                } else {
                    LOG.info("no message integrity check");
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] encrypt(byte[] data, String publicKey, boolean withIntegrityCheck) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Boolean lambda$encrypt$2(PGPPublicKeyRing it) {
        Functions.Function1 _function_1 = it_1 -> it_1.isEncryptionKey();
        return ((PGPPublicKey)IteratorExtensions.findFirst((Iterator)it.getPublicKeys(), (Functions.Function1)_function_1)).isEncryptionKey();
    }
}

