/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.configure.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class SslEntity {
  private boolean useClientCA;
  
  private String keyStoreType;
  
  private String keyFilePath;
  
  private String managerPwd;
  
  private String storePwd;
  
  @Pure
  public boolean isUseClientCA() {
    return this.useClientCA;
  }
  
  public void setUseClientCA(final boolean useClientCA) {
    this.useClientCA = useClientCA;
  }
  
  @Pure
  public String getKeyStoreType() {
    return this.keyStoreType;
  }
  
  public void setKeyStoreType(final String keyStoreType) {
    this.keyStoreType = keyStoreType;
  }
  
  @Pure
  public String getKeyFilePath() {
    return this.keyFilePath;
  }
  
  public void setKeyFilePath(final String keyFilePath) {
    this.keyFilePath = keyFilePath;
  }
  
  @Pure
  public String getManagerPwd() {
    return this.managerPwd;
  }
  
  public void setManagerPwd(final String managerPwd) {
    this.managerPwd = managerPwd;
  }
  
  @Pure
  public String getStorePwd() {
    return this.storePwd;
  }
  
  public void setStorePwd(final String storePwd) {
    this.storePwd = storePwd;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("useClientCA", this.useClientCA);
    b.add("keyStoreType", this.keyStoreType);
    b.add("keyFilePath", this.keyFilePath);
    b.add("managerPwd", this.managerPwd);
    b.add("storePwd", this.storePwd);
    return b.toString();
  }
}
