/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class AES implements ICrypto {
  private final Logger LOG = LoggerFactory.getLogger(AES.class);
  
  /**
   * The default iv.
   */
  private byte[] defaultIv = { ((byte) 0x32), ((byte) 0x46), ((byte) 0xfe), ((byte) 0xab), ((byte) 0xfc), ((byte) 0x2d), ((byte) 0x15), ((byte) 0xfa), ((byte) 0x32), ((byte) 0x46), ((byte) 0xfe), ((byte) 0xab), ((byte) 0xfc), ((byte) 0x2d), ((byte) 0x15), ((byte) 0xfa) };
  
  /**
   * The Constant key.
   */
  private String key = "70rEwsfQZBUW+LB2l16RfMgcARMHqDsV";
  
  private ICrypto c;
  
  private byte[] src;
  
  public AES(final byte[] src) {
    this.src = src;
  }
  
  public AES(final String key, final ICrypto c) {
    this.key = key;
    this.c = c;
  }
  
  public AES(final String key, final byte[] iv, final ICrypto c) {
    this.key = key;
    this.c = c;
    this.defaultIv = iv;
  }
  
  public AES(final ICrypto c) {
    this.c = c;
  }
  
  /**
   * 加密.
   */
  public byte[] encryptBytes(final byte[] src) throws Exception {
    byte[] _bytes = this.key.getBytes();
    SecretKey secretKey = new SecretKeySpec(_bytes, "AES");
    Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
    IvParameterSpec IVSpec = new IvParameterSpec(this.defaultIv);
    cipher.init(Cipher.ENCRYPT_MODE, secretKey, IVSpec);
    return cipher.doFinal(src);
  }
  
  /**
   * 解密.
   */
  public byte[] decryptBytes(final byte[] srcBytes) throws Exception {
    byte[] _bytes = this.key.getBytes();
    SecretKey secretKey = new SecretKeySpec(_bytes, "AES");
    IvParameterSpec IVSpec = new IvParameterSpec(this.defaultIv);
    Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
    cipher.init(Cipher.DECRYPT_MODE, secretKey, IVSpec);
    return cipher.doFinal(srcBytes);
  }
  
  /**
   * Gen key.
   */
  private static String createAESKey() throws NoSuchAlgorithmException {
    byte[] keyBytes = UUID.randomUUID().toString().getBytes();
    KeyGenerator desEde = KeyGenerator.getInstance("AES");
    SecureRandom _secureRandom = new SecureRandom(keyBytes);
    desEde.init(_secureRandom);
    SecretKey key = desEde.generateKey();
    byte[] _encoded = key.getEncoded();
    ICrypto base64 = new Base64(_encoded);
    byte[] _encode = base64.encode();
    return new String(_encode);
  }
  
  @Override
  public byte[] encode() {
    if ((this.c != null)) {
      try {
        return this.encryptBytes(this.c.encode());
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception e = (Exception)_t;
          this.LOG.info("encode : ", e);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    try {
      return this.encryptBytes(this.src);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        this.LOG.info("encode : ", e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return null;
  }
  
  @Override
  public byte[] decode() {
    try {
      if ((this.c != null)) {
        byte[] des3Src = this.decryptBytes(this.c.getData());
        this.c.setData(des3Src);
        return this.c.decode();
      } else {
        return this.decryptBytes(this.src);
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        this.LOG.info("decode : ", e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return null;
  }
  
  @Override
  public byte[] getData() {
    return this.src;
  }
  
  @Override
  public ICrypto setData(final byte[] src) {
    this.src = src;
    return this;
  }
}
