/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.utils;

import cool.taomu.framework.crypto.Base64;
import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class FileToBase64StringUtils {
  public static void FileToBase64String(final String inputPath, final String outputPath) {
    try {
      File _file = new File(inputPath);
      FileInputStream input = new FileInputStream(_file);
      byte[] bf = new byte[input.available()];
      input.read(bf);
      Base64 base64 = new Base64(bf);
      File _file_1 = new File(outputPath);
      FileUtils.writeByteArrayToFile(_file_1, base64.encode(), true);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void base64ToFile(final String inputPath, final String outputPath) {
    try {
      File _file = new File(inputPath);
      byte[] input = FileUtils.readFileToByteArray(_file);
      Base64 base64 = new Base64(input);
      File _file_1 = new File(outputPath);
      FileUtils.writeByteArrayToFile(_file_1, base64.decode(), true);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
