package cool.taomu.framework.utils;

import cool.taomu.framework.inter.IShareMemory;
import cool.taomu.framework.spi.annotation.Spi;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Spi("TmShareMemory")
@SuppressWarnings("all")
public class TmShareMemory implements IShareMemory {
  private int shareMemorySzie = 41779264;
  
  private int fileSize = 0;
  
  private MappedByteBuffer mmap = null;
  
  private FileChannel fcl = null;
  
  private RandomAccessFile raf = null;
  
  public TmShareMemory(final String file) {
    this.setFilename(file);
  }
  
  public TmShareMemory() {
  }
  
  @Override
  public synchronized int write(final int start, final int size, final byte[] buffer) {
    try {
      if (((start >= this.fileSize) || ((start + size) >= this.fileSize))) {
        return 0;
      }
      FileLock flock = null;
      try {
        flock = this.fcl.lock(start, size, false);
        if ((flock != null)) {
          this.mmap.position(start);
          this.mmap.put(ByteBuffer.wrap(buffer));
          flock.release();
          return size;
        }
      } catch (final Throwable _t) {
        if (_t instanceof IOException) {
          if ((flock != null)) {
            flock.release();
          }
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      return 0;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public synchronized int read(final int start, final int size, final byte[] buffer) {
    try {
      if ((start >= this.fileSize)) {
        return 0;
      }
      FileLock flock = null;
      int _size = size;
      try {
        flock = this.fcl.lock(start, size, false);
        if ((flock != null)) {
          this.mmap.position(start);
          int _remaining = this.mmap.remaining();
          boolean _lessThan = (_remaining < size);
          if (_lessThan) {
            _size = this.mmap.remaining();
          }
          if ((_size > 0)) {
            this.mmap.get(buffer, 0, _size);
          }
          flock.release();
          return _size;
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          if ((flock != null)) {
            flock.release();
          }
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      return 0;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public void close() throws Exception {
    if ((this.fcl != null)) {
      this.fcl.close();
    }
    if ((this.raf != null)) {
      this.raf.close();
    }
    this.mmap = null;
  }
  
  public static void main(final String[] args) {
    try {
      TmShareMemory sm = new TmShareMemory("/home/rcmu/a.txt");
      String a = "Hello World";
      sm.write(40, 20, a.getBytes());
      byte[] b = new byte[20];
      sm.read(40, 20, b);
      String _string = new String(b, "UTF-8");
      System.out.println(_string);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public void setFilename(final String filename) {
    try {
      RandomAccessFile _randomAccessFile = new RandomAccessFile(filename, "rw");
      this.raf = _randomAccessFile;
      this.fcl = this.raf.getChannel();
      long _size = this.fcl.size();
      this.fileSize = ((int) _size);
      if ((this.fileSize < this.shareMemorySzie)) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[((int) (this.shareMemorySzie - this.fileSize))]);
        bb.clear();
        this.fcl.position(this.fileSize);
        this.fcl.write(bb);
        this.fcl.force(false);
        this.fileSize = this.shareMemorySzie;
      }
      this.mmap = this.fcl.map(FileChannel.MapMode.READ_WRITE, 0, this.fileSize);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
