/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils;

import cool.taomu.framework.inter.IShareMemory;
import cool.taomu.framework.spi.annotation.Spi;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Spi(value="TmShareMemory")
public class TmShareMemory
implements IShareMemory {
    private int shareMemorySzie = 41779264;
    private int fileSize = 0;
    private MappedByteBuffer mmap = null;
    private FileChannel fcl = null;
    private RandomAccessFile raf = null;

    public TmShareMemory(String file) {
        this.setFilename(file);
    }

    public TmShareMemory() {
    }

    public synchronized int write(int start, int size, byte[] buffer) {
        try {
            if (start >= this.fileSize || start + size >= this.fileSize) {
                return 0;
            }
            FileLock flock = null;
            try {
                flock = this.fcl.lock(start, size, false);
                if (flock != null) {
                    this.mmap.position(start);
                    this.mmap.put(ByteBuffer.wrap(buffer));
                    flock.release();
                    return size;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    if (flock != null) {
                        flock.release();
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return 0;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public synchronized int read(int start, int size, byte[] buffer) {
        try {
            if (start >= this.fileSize) {
                return 0;
            }
            FileLock flock = null;
            int _size = size;
            try {
                flock = this.fcl.lock(start, size, false);
                if (flock != null) {
                    boolean _lessThan;
                    this.mmap.position(start);
                    int _remaining = this.mmap.remaining();
                    boolean bl = _lessThan = _remaining < size;
                    if (_lessThan) {
                        _size = this.mmap.remaining();
                    }
                    if (_size > 0) {
                        this.mmap.get(buffer, 0, _size);
                    }
                    flock.release();
                    return _size;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    if (flock != null) {
                        flock.release();
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return 0;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void close() throws Exception {
        if (this.fcl != null) {
            this.fcl.close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
        this.mmap = null;
    }

    public static void main(String[] args) {
        try {
            TmShareMemory sm = new TmShareMemory("/home/rcmu/a.txt");
            String a = "Hello World";
            sm.write(40, 20, a.getBytes());
            byte[] b = new byte[20];
            sm.read(40, 20, b);
            String _string = new String(b, "UTF-8");
            System.out.println(_string);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setFilename(String filename) {
        try {
            RandomAccessFile _randomAccessFile;
            this.raf = _randomAccessFile = new RandomAccessFile(filename, "rw");
            this.fcl = this.raf.getChannel();
            long _size = this.fcl.size();
            this.fileSize = (int)_size;
            if (this.fileSize < this.shareMemorySzie) {
                ByteBuffer bb = ByteBuffer.wrap(new byte[this.shareMemorySzie - this.fileSize]);
                bb.clear();
                this.fcl.position(this.fileSize);
                this.fcl.write(bb);
                this.fcl.force(false);
                this.fileSize = this.shareMemorySzie;
            }
            this.mmap = this.fcl.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileSize);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

