/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils.asm;

import com.google.common.base.Objects;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.TraceClassVisitor;

public final class BytecodeUtils
extends ClassLoader {
    private ClassWriter cwriter;
    private ClassVisitor tcvisitor;
    private GeneratorAdapter ga;
    private final String name;
    private String superClassName;
    private int version;
    private final ConcurrentHashMap<String, Variable> localVariable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Label> localLabel = new ConcurrentHashMap();

    public BytecodeUtils() {
        this(String.format("%s.%s%s", "cool.taomu.software.fig", "TaoMu", UUID.randomUUID().toString().replace("-", "")).replace(".", "/"));
    }

    public BytecodeUtils(String name) {
        this(52, name);
    }

    public BytecodeUtils(int version, String name) {
        ClassWriter _classWriter;
        this.cwriter = _classWriter = new ClassWriter(3);
        PrintWriter _printWriter = new PrintWriter(System.err);
        TraceClassVisitor _traceClassVisitor = new TraceClassVisitor((ClassVisitor)this.cwriter, _printWriter);
        this.tcvisitor = _traceClassVisitor;
        this.name = name;
        this.version = version;
    }

    public BytecodeUtils createClass(int access, Class<?> superClass, String ... inters) {
        this.superClassName = superClass.getTypeName();
        this.tcvisitor.visit(this.version, access, this.name, null, this.superClassName, inters);
        return this;
    }

    public BytecodeUtils createClass(Class<?> superClass, String ... inters) {
        return this.createClass(1, superClass, inters);
    }

    public BytecodeUtils createClass(String ... inters) {
        return this.createClass(Object.class, inters);
    }

    public BytecodeUtils createClass() {
        return this.createClass(null);
    }

    public BytecodeUtils createInterface(String ... inters) {
        return this.createClass(1537, Object.class, inters);
    }

    public BytecodeUtils createAbstract(Class<?> superClass, String ... inters) {
        return this.createClass(1025, superClass, inters);
    }

    public BytecodeUtils createAbstract(String ... inters) {
        return this.createAbstract(Object.class, inters);
    }

    public BytecodeUtils createAbstract() {
        return this.createAbstract(null);
    }

    public BytecodeUtils init(Constructor<?>[] constructor) {
        Consumer<Constructor> _function = it -> {
            boolean _greaterThan;
            Method m = Method.getMethod((Constructor)it);
            GeneratorAdapter ga = new GeneratorAdapter(1, m, null, null, this.tcvisitor);
            ga.loadThis();
            int _size = ((List)Conversions.doWrapArray((Object)it.getParameters())).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                int _size_1 = ((List)Conversions.doWrapArray((Object)it.getParameters())).size();
                int _minus = _size_1 - 1;
                ga.loadArgs(0, _minus);
            }
            ga.invokeConstructor(Type.getObjectType((String)this.superClassName), m);
            ga.returnValue();
            ga.endMethod();
        };
        IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray(constructor))).forEach(_function);
        return this;
    }

    public BytecodeUtils createField(String name, int access, final Class<?> type, Object value) {
        this.tcvisitor.visitField(access, name, Type.getType(type).getDescriptor(), null, value).visitEnd();
        if (access == 2 || access == 4) {
            String fName = StringExtensions.toFirstUpper((String)name);
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"set", fName})));
            String _name = type.getName();
            BytecodeUtils m = this.createMethod(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"void", _join, "(", _name, ")"})), (CharSequence)" "), false);
            m.coding(GeneratorAdapter.class, new Asm<GeneratorAdapter>(){

                @Override
                public void coding(GeneratorAdapter it) {
                    it.loadThis();
                    it.loadArg(0);
                    it.putField(Type.getObjectType((String)BytecodeUtils.this.name), it.getName(), Type.getType((Class)type));
                }
            }).returnValue().endMethod();
            String _name_1 = type.getName();
            String _join_1 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"get", fName})));
            m = this.createMethod(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name_1, _join_1, "(", ")"})), (CharSequence)" "), false);
            m.coding(GeneratorAdapter.class, new Asm<GeneratorAdapter>(){

                @Override
                public void coding(GeneratorAdapter it) {
                    it.loadThis();
                    it.getField(Type.getObjectType((String)BytecodeUtils.this.name), it.getName(), Type.getType((Class)type));
                }
            }).returnValue().endMethod();
        }
        return this;
    }

    public BytecodeUtils createMethod(String method, boolean defaultPackage) {
        return this.createMethod(1, method, defaultPackage);
    }

    public BytecodeUtils createMethod(String method) {
        return this.createMethod(method, true);
    }

    public BytecodeUtils createMethod(int access, String method, boolean defaultPackage) {
        GeneratorAdapter _generatorAdapter;
        Method _method = Method.getMethod((String)method, (boolean)defaultPackage);
        this.ga = _generatorAdapter = new GeneratorAdapter(access, _method, null, null, this.tcvisitor);
        return this;
    }

    public BytecodeUtils createMethod(java.lang.reflect.Method method) {
        return this.createMethod(1, method);
    }

    public BytecodeUtils createMethod(int access, java.lang.reflect.Method method) {
        GeneratorAdapter _generatorAdapter;
        Method _method = Method.getMethod((java.lang.reflect.Method)method);
        this.ga = _generatorAdapter = new GeneratorAdapter(access, _method, null, null, this.tcvisitor);
        return this;
    }

    public BytecodeUtils invokeVirtual(String internalName, String method, boolean defaultPackage) {
        this.ga.invokeVirtual(Type.getObjectType((String)internalName.replace(".", "/")), Method.getMethod((String)method, (boolean)defaultPackage));
        return this;
    }

    public BytecodeUtils invokeVirtual(String internalName, String method) {
        return this.invokeVirtual(internalName, method, true);
    }

    public BytecodeUtils invokeVirtual(Class<?> zlass, java.lang.reflect.Method method) {
        return this.invokeVirtual(zlass.getName(), method);
    }

    public BytecodeUtils invokeVirtual(Class<?> zlass, String method) {
        return this.invokeVirtual(zlass.getName(), method);
    }

    public BytecodeUtils invokeVirtual(String internalName, java.lang.reflect.Method method) {
        this.ga.invokeVirtual(Type.getObjectType((String)internalName.replace(".", "/")), Method.getMethod((java.lang.reflect.Method)method));
        return this;
    }

    public BytecodeUtils invokeStatic(Class<?> type, String method) {
        return this.invokeStatic(type.getName(), method, true);
    }

    public BytecodeUtils invokeStatic(String internalName, String method, boolean defaultPackage) {
        this.ga.invokeStatic(Type.getObjectType((String)internalName.replace(".", "/")), Method.getMethod((String)method, (boolean)defaultPackage));
        return this;
    }

    public BytecodeUtils invokeDynamic(int tag, String internalName, Method method) {
        MethodType mt = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
        String owner = Type.getObjectType((String)internalName.replace(".", "/")).getInternalName();
        String _methodDescriptorString = mt.toMethodDescriptorString();
        Handle bootstrap = new Handle(tag, owner, "bootstrap", _methodDescriptorString, false);
        this.ga.invokeDynamic(method.getName(), method.getDescriptor(), bootstrap, new Object[0]);
        return this;
    }

    public BytecodeUtils invokeDynamic(Class<?> zlass, Method method) {
        return this.invokeDynamic(6, zlass.getName(), method);
    }

    public BytecodeUtils returnValue() {
        this.ga.returnValue();
        return this;
    }

    public BytecodeUtils load(String key) {
        boolean _containsKey = this.localVariable.containsKey(key);
        if (_containsKey) {
            Variable local = this.localVariable.get(key);
            this.ga.loadLocal(local.index.intValue(), local.type);
        }
        return this;
    }

    public BytecodeUtils store(String key, Class<?> zlass) {
        int index = this.ga.newLocal(Type.getType(zlass));
        this.ga.storeLocal(index, Type.getType(zlass));
        Type _type = Type.getType(zlass);
        Variable _variable = new Variable(index, _type);
        this.localVariable.put(key, _variable);
        return this;
    }

    public BytecodeUtils mark(String key) {
        boolean _containsKey = this.localLabel.containsKey(key);
        if (_containsKey) {
            this.ga.mark(this.localLabel.get(key));
        } else {
            Label label = this.ga.newLabel();
            this.localLabel.put(key, label);
            this.ga.mark(label);
        }
        return this;
    }

    public BytecodeUtils goTo(String key) {
        boolean _containsKey = this.localLabel.containsKey(key);
        if (_containsKey) {
            this.ga.goTo(this.localLabel.get(key));
        } else {
            Label label = this.ga.newLabel();
            this.localLabel.put(key, label);
            this.ga.goTo(label);
        }
        return this;
    }

    public BytecodeUtils ifNull(String key) {
        boolean _containsKey = this.localLabel.containsKey(key);
        if (_containsKey) {
            this.ga.ifNull(this.localLabel.get(key));
        } else {
            Label label = this.ga.newLabel();
            this.localLabel.put(key, label);
            this.ga.ifNull(this.localLabel.get(key));
        }
        return this;
    }

    public BytecodeUtils ifNonNull(String key) {
        boolean _containsKey = this.localLabel.containsKey(key);
        if (_containsKey) {
            this.ga.ifNonNull(this.localLabel.get(key));
        } else {
            Label label = this.ga.newLabel();
            this.localLabel.put(key, label);
            this.ga.ifNonNull(this.localLabel.get(key));
        }
        return this;
    }

    public BytecodeUtils ifCmp(String key, int mode, Class<?> zlass) {
        boolean _containsKey = this.localLabel.containsKey(key);
        if (_containsKey) {
            this.ga.ifCmp(Type.getType(zlass), mode, this.localLabel.get(key));
        } else {
            Label label = this.ga.newLabel();
            this.localLabel.put(key, label);
            this.ga.ifCmp(Type.getType(zlass), mode, label);
        }
        return this;
    }

    public BytecodeUtils checkCast(Class<?> type) {
        this.ga.checkCast(Type.getType(type));
        return this;
    }

    public BytecodeUtils dup() {
        this.ga.dup();
        return this;
    }

    public BytecodeUtils push(int index) {
        this.ga.push(index);
        return this;
    }

    public BytecodeUtils push(String value) {
        this.ga.push(value);
        return this;
    }

    public BytecodeUtils loadArg(int index) {
        this.ga.loadArg(index);
        return this;
    }

    public <T> BytecodeUtils coding(Class<T> zlass, Asm<T> code) {
        boolean _equals = zlass.equals(BytecodeUtils.class);
        if (_equals) {
            code.coding((GeneratorAdapter)zlass.cast(this));
        } else {
            boolean _equals_1 = zlass.equals(GeneratorAdapter.class);
            if (_equals_1) {
                code.coding(this.ga);
            }
        }
        return this;
    }

    public BytecodeUtils endMethod() {
        this.ga.endMethod();
        return this;
    }

    public BytecodeUtils buildReturnValue(java.lang.reflect.Method m) {
        Class<?> _returnType = m.getReturnType();
        boolean _matched = false;
        if (Objects.equal(_returnType, Integer.TYPE)) {
            _matched = true;
            this.checkCast(Integer.class);
            this.invokeVirtual(Integer.class, "int intValue()");
        }
        if (!_matched && Objects.equal(_returnType, Long.TYPE)) {
            _matched = true;
            this.checkCast(Long.class);
            this.invokeVirtual(Long.class, "long longValue()");
        }
        if (!_matched && Objects.equal(_returnType, Double.TYPE)) {
            _matched = true;
            this.checkCast(Double.class);
            this.invokeVirtual(Double.class, "double doubleValue()");
        }
        if (!_matched && Objects.equal(_returnType, Float.TYPE)) {
            _matched = true;
            this.checkCast(Float.class);
            this.invokeVirtual(Float.class, "float floatValue()");
        }
        if (!_matched && Objects.equal(_returnType, Boolean.TYPE)) {
            _matched = true;
            this.checkCast(Boolean.class);
            this.invokeVirtual(Boolean.class, "boolean booleanValue()");
        }
        if (!_matched && Objects.equal(_returnType, Short.TYPE)) {
            _matched = true;
            this.checkCast(Short.class);
            this.invokeVirtual(Short.class, "short shortValue()");
        }
        if (!_matched && Objects.equal(_returnType, Character.TYPE)) {
            _matched = true;
            this.checkCast(Character.class);
            this.invokeVirtual(Character.class, "char charValue()");
        }
        if (!_matched && Objects.equal(_returnType, Byte.TYPE)) {
            _matched = true;
            this.checkCast(Byte.class);
            this.invokeVirtual(Byte.class, "byte byteValue()");
        }
        if (!_matched && Objects.equal(_returnType, Void.TYPE)) {
            _matched = true;
        }
        if (!_matched) {
            this.checkCast(m.getReturnType());
        }
        return this;
    }

    public BytecodeUtils buildArguments(Method method) {
        boolean _greaterThan;
        int _size = ((List)Conversions.doWrapArray((Object)method.getArgumentTypes())).size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            for (int index = 0; index < ((List)Conversions.doWrapArray((Object)method.getArgumentTypes())).size(); ++index) {
                this.dup();
                this.push(index);
                String _descriptor = method.getArgumentTypes()[index].getDescriptor();
                if (_descriptor != null) {
                    switch (_descriptor) {
                        case "Z": {
                            this.loadArg(index);
                            this.invokeStatic(Boolean.class, "Boolean valueOf(boolean)");
                            break;
                        }
                        case "C": {
                            this.loadArg(index);
                            this.invokeStatic(Character.class, "Character valueOf(char)");
                            break;
                        }
                        case "B": {
                            this.loadArg(index);
                            this.invokeStatic(Byte.class, "Byte valueOf(byte)");
                            break;
                        }
                        case "S": {
                            this.loadArg(index);
                            this.invokeStatic(Short.class, "Short valueOf(short)");
                            break;
                        }
                        case "I": {
                            this.loadArg(index);
                            this.invokeStatic(Integer.class, "Integer valueOf(int)");
                            break;
                        }
                        case "F": {
                            this.loadArg(index);
                            this.invokeStatic(Float.class, "Float valueOf(float)");
                            break;
                        }
                        case "J": {
                            this.loadArg(index);
                            this.invokeStatic(Float.class, "Long valueOf(long)");
                            break;
                        }
                        case "D": {
                            this.loadArg(index);
                            this.invokeStatic(Float.class, "Double valueOf(double)");
                            break;
                        }
                        default: {
                            this.ga.visitVarInsn(25, index + 1);
                            break;
                        }
                    }
                } else {
                    this.ga.visitVarInsn(25, index + 1);
                }
                this.ga.visitInsn(83);
            }
        } else {
            this.ga.visitInsn(1);
        }
        return this;
    }

    public BytecodeUtils end() {
        this.tcvisitor.visitEnd();
        return this;
    }

    public byte[] toByteArray() {
        return this.cwriter.toByteArray();
    }

    @Override
    public Class<?> findClass(String name) {
        byte[] bytes = this.toByteArray();
        return super.defineClass(name, bytes, 0, bytes.length);
    }

    public static interface Asm<T> {
        public void coding(T var1);
    }

    @Accessors
    public static final class Variable {
        private Integer index;
        private Type type;

        public Variable(Integer index, Type type) {
            this.index = index;
            this.type = type;
        }

        @Pure
        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        @Pure
        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }
    }
}

