/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.crypto;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SslUtil {
    private KeyStore keyStore;

    public SslUtil(String keyStoreType) {
        try {
            String _xifexpression = null;
            _xifexpression = keyStoreType == null ? "JKS" : keyStoreType;
            this.keyStore = KeyStore.getInstance(_xifexpression);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public TrustManagerFactory trustManageFactory() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.keyStore);
            return tmf;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public TrustManagerFactory trustManageFactory(String sslKeyFilePath, String sslStorePwd) {
        try {
            FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
            this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            tmf.init(this.keyStore);
            return tmf;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public KeyManagerFactory keyManageFactory(String sslKeyFilePath, String sslManagerPwd, String sslStorePwd) {
        try {
            FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
            this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(this.keyStore, sslManagerPwd.toCharArray());
            return kmf;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

