/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.objectpool;

import cool.taomu.framework.configure.ConfigureManage;
import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.objectpool.ObjectPool;
import cool.taomu.framework.utils.reflect.ReflectUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPoolFactory
extends BaseKeyedPooledObjectFactory<Class<Object>, ObjectPool> {
    private AtomicInteger idCount = new AtomicInteger(1);
    private static final Logger LOG = LoggerFactory.getLogger(ObjectPoolFactory.class);
    private static Object pool = null;
    private static final String SPRING_AUTOWIRED = "org.springframework.beans.factory.annotation.Autowired";

    public static synchronized GenericKeyedObjectPool<Class<Object>, ObjectPool> getInstance() {
        if (pool == null) {
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            ConfigureEntity yml = ConfigureManage.loadConfig();
            config.setMaxTotalPerKey(yml.getPool().getMaxTotalPerKey().intValue());
            config.setMaxIdlePerKey(yml.getPool().getMaxIdlePerKey().intValue());
            config.setMinIdlePerKey(yml.getPool().getMinIdlePerKey().intValue());
            config.setLifo(yml.getPool().isLifo());
            ObjectPoolFactory _objectPoolFactory = new ObjectPoolFactory();
            GenericKeyedObjectPool _genericKeyedObjectPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)_objectPoolFactory, config);
            pool = _genericKeyedObjectPool;
        }
        return (GenericKeyedObjectPool)pool;
    }

    public static void perparePool(Class<Object> key) {
        try {
            ObjectPoolFactory.getInstance().preparePool(key);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ObjectPool borrowObject(Class<Object> key) {
        try {
            return (ObjectPool)ObjectPoolFactory.getInstance().borrowObject(key);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void returnObject(Class<Object> key, ObjectPool obj) {
        ObjectPoolFactory.getInstance().returnObject(key, (Object)obj);
    }

    public PooledObject<ObjectPool> makeObject(Class<Object> key) throws Exception {
        LOG.info("\u521b\u5efa\u5bf9\u8c61:" + key);
        return super.makeObject(key);
    }

    public void activateObject(Class<Object> key, PooledObject<ObjectPool> p) throws Exception {
        String _name = key.getName();
        String _plus = "\u6d3b\u52a8\u5bf9\u8c61\uff1a" + _name;
        String _plus_1 = _plus + " ==> ";
        int _id = ((ObjectPool)p.getObject()).getId();
        String _plus_2 = _plus_1 + Integer.valueOf(_id);
        LOG.info(_plus_2);
        super.activateObject(key, p);
    }

    public void destroyObject(Class<Object> key, PooledObject<ObjectPool> p) throws Exception {
        int _id = ((ObjectPool)p.getObject()).getId();
        String _plus = "\u9500\u6bc1\u5bf9\u8c61:" + key + " ==> " + Integer.valueOf(_id);
        LOG.info(_plus);
        super.destroyObject(key, p);
    }

    public void passivateObject(Class<Object> key, PooledObject<ObjectPool> p) throws Exception {
        int _id = ((ObjectPool)p.getObject()).getId();
        String _plus = "\u5f52\u8fd8\u5bf9\u8c61:" + key + " ==> " + Integer.valueOf(_id);
        LOG.info(_plus);
        super.passivateObject(key, p);
    }

    public PooledObject<ObjectPool> wrap(ObjectPool value) {
        return new DefaultPooledObject((Object)value);
    }

    public ObjectPool create(Class<Object> zlass) throws Exception {
        Field[] fields;
        Object instance = zlass.newInstance();
        for (Field field : fields = ReflectUtils.getReflectFields(zlass)) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> _loadClass = loader.loadClass(SPRING_AUTOWIRED);
                Object ann = field.getAnnotation(_loadClass);
                if (ann == null) continue;
                ReflectUtils.setReflectFields(zlass, field.getName(), instance, this.getSpringBean(field.getType()));
            }
            catch (Throwable _t) {
                if (_t instanceof ClassNotFoundException) {
                    ClassNotFoundException ex = (ClassNotFoundException)_t;
                    LOG.debug("Class Not Found Exception", (Throwable)ex);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        int _andAdd = this.idCount.getAndAdd(1);
        return new ObjectPool(instance, _andAdd);
    }

    public Object getSpringBean(Class<?> zlass) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> registerBeanToSpring = loader.loadClass("cool.taomu.framework.springplugin.TaomuFramework");
            if (registerBeanToSpring != null) {
                MethodType desc = MethodType.methodType(Object.class, Class.class);
                MethodHandle methodHandle = MethodHandles.lookup().findStatic(registerBeanToSpring, "getBean", desc);
                Object bean = methodHandle.invokeExact(zlass);
                if (bean != null) {
                    LOG.info("\u4ecespring\u4e2d\u6210\u529f\u83b7\u53d6\u4e00\u4e2abean");
                } else {
                    LOG.info("\u4ecespring\u4e2d\u672a\u83b7\u53d6\u5230\u4e00\u4e2abean");
                }
                return bean;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                Throwable e = _t;
                LOG.debug("", e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return null;
    }
}

