/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils.crypto;

import cool.taomu.framework.crypto.Base64;
import java.io.File;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class PgpKeyTool {
    private static PGPKeyPair genKeyPair(int rsaWidth) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(rsaWidth);
            KeyPair kp = kpg.generateKeyPair();
            Date _date = new Date();
            return new JcaPGPKeyPair(1, kp, _date);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static PGPSecretKey getSecretKey(String identity, String passPhrase, int rsaWidth) {
        try {
            PGPKeyPair keyPair = PgpKeyTool.genKeyPair(rsaWidth);
            PGPDigestCalculator sha1Calc = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
            int _algorithm = keyPair.getPublicKey().getAlgorithm();
            JcaPGPContentSignerBuilder _jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(_algorithm, 2);
            PBESecretKeyEncryptor _build = new JcePBESecretKeyEncryptorBuilder(3, sha1Calc).setProvider("BC").build(passPhrase.toCharArray());
            return new PGPSecretKey(16, keyPair, identity, sha1Calc, null, null, (PGPContentSignerBuilder)_jcaPGPContentSignerBuilder, _build);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getPrivateKey(PGPSecretKey key) {
        try {
            byte[] _encoded = key.getEncoded();
            byte[] _encode = new Base64(_encoded).encode();
            Charset _forName = Charset.forName("UTF-8");
            return new String(_encode, _forName);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getPublicKey(PGPSecretKey key) {
        try {
            PGPPublicKey pkey = key.getPublicKey();
            byte[] _encoded = pkey.getEncoded();
            byte[] _encode = new Base64(_encoded).encode();
            Charset _forName = Charset.forName("UTF-8");
            return new String(_encode, _forName);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void main(String[] args) {
        try {
            BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider((Provider)_bouncyCastleProvider);
            PGPSecretKey skey = PgpKeyTool.getSecretKey("aaa", "123456789", 2048);
            File _file = new File("privateKey1.txt");
            FileUtils.writeStringToFile((File)_file, (String)PgpKeyTool.getPrivateKey(skey), (Charset)Charset.forName("UTF-8"));
            File _file_1 = new File("publicKey1.txt");
            FileUtils.writeStringToFile((File)_file_1, (String)PgpKeyTool.getPublicKey(skey), (Charset)Charset.forName("UTF-8"));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

