/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils.runtime;

import com.sun.management.OperatingSystemMXBean;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
public class RuntimeInfo {
    private String vmInfo;
    private String javaInfo;
    private long jvmMemUsed;
    private long jvmMemTotal;
    private long jvmMemFree;
    private long jvmMemMax;
    private long heapMemUsed;
    private long heapMemMax;
    private long heapMemCommitted;
    private String osInfo;
    private long memUsed;
    private long memFree;
    private long memTotal;
    private int threadTotalNum;
    private String pid;
    private long loadedClassCount;
    private long totalloadedClassCount;
    private long unloadedClassCount;
    private int cpuTemp;

    public RuntimeInfo() {
        try {
            long _divide_6;
            long _divide_5;
            long _divide_4;
            long _divide_2;
            long _divide_1;
            long _divide;
            long vmFree = 0L;
            long vmUse = 0L;
            long vmTotal = 0L;
            long vmMax = 0L;
            int byteToMb = 0x100000;
            Runtime rt = Runtime.getRuntime();
            long _talMemory = rt.totalMemory();
            vmTotal = _divide = _talMemory / (long)byteToMb;
            long _freeMemory = rt.freeMemory();
            vmFree = _divide_1 = _freeMemory / (long)byteToMb;
            long _maxMemory = rt.maxMemory();
            vmMax = _divide_2 = _maxMemory / (long)byteToMb;
            vmUse = vmTotal - vmFree;
            this.jvmMemFree = vmFree;
            this.jvmMemUsed = vmUse;
            this.jvmMemTotal = vmTotal;
            this.jvmMemMax = vmMax;
            java.lang.management.OperatingSystemMXBean _operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            OperatingSystemMXBean osmxb = (OperatingSystemMXBean)_operatingSystemMXBean;
            String os = String.format("%s arch %s version %s available %s", osmxb.getName(), osmxb.getArch(), osmxb.getVersion(), osmxb.getAvailableProcessors());
            long _freePhysicalMemorySize = osmxb.getFreePhysicalMemorySize();
            long physicalFree = _freePhysicalMemorySize / (long)byteToMb;
            long _totalPhysicalMemorySize = osmxb.getTotalPhysicalMemorySize();
            long physicalTotal = _totalPhysicalMemorySize / (long)byteToMb;
            long physicalUse = physicalTotal - physicalFree;
            this.osInfo = os;
            boolean _contains = this.osInfo.contains("Linux");
            if (_contains) {
                int _divide_3;
                InputStream temp = Runtime.getRuntime().exec("cat /sys/class/thermal/thermal_zone0/temp").getInputStream();
                String temp1 = IOUtils.toString((InputStream)temp, (String)"UTF-8");
                boolean _equals = temp1.equals("");
                if (_equals) {
                    temp = Runtime.getRuntime().exec("cat /sys/class/hwmon/hwmon0/in0_input").getInputStream();
                }
                String temperature = IOUtils.toString((InputStream)temp, (String)"UTF-8").trim();
                int _parseInt = Integer.parseInt(temperature);
                this.cpuTemp = _divide_3 = _parseInt / 1000;
            }
            this.memFree = physicalFree;
            this.memUsed = physicalUse;
            this.memTotal = physicalTotal;
            ThreadGroup parentThread = null;
            int totalThread = 0;
            parentThread = Thread.currentThread().getThreadGroup();
            while (parentThread.getParent() != null) {
                totalThread = parentThread.activeCount();
                parentThread = parentThread.getParent();
            }
            this.threadTotalNum = totalThread;
            this.pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            this.vmInfo = String.format("%s version %s", runtime.getVmName(), runtime.getVmVersion());
            this.javaInfo = String.format("%s java version %s", runtime.getVmVendor(), System.getProperty("java.version"));
            ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
            this.loadedClassCount = cl.getLoadedClassCount();
            this.totalloadedClassCount = cl.getTotalLoadedClassCount();
            this.unloadedClassCount = cl.getUnloadedClassCount();
            MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
            long _used = mem.getHeapMemoryUsage().getUsed();
            this.heapMemUsed = _divide_4 = _used / (long)byteToMb;
            long _max = mem.getHeapMemoryUsage().getMax();
            this.heapMemMax = _divide_5 = _max / (long)byteToMb;
            long _committed = mem.getHeapMemoryUsage().getCommitted();
            this.heapMemCommitted = _divide_6 = _committed / (long)byteToMb;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void main(String[] args) {
        RuntimeInfo a = new RuntimeInfo();
        InputOutput.println((Object)a);
    }

    @Pure
    public String getVmInfo() {
        return this.vmInfo;
    }

    public void setVmInfo(String vmInfo) {
        this.vmInfo = vmInfo;
    }

    @Pure
    public String getJavaInfo() {
        return this.javaInfo;
    }

    public void setJavaInfo(String javaInfo) {
        this.javaInfo = javaInfo;
    }

    @Pure
    public long getJvmMemUsed() {
        return this.jvmMemUsed;
    }

    public void setJvmMemUsed(long jvmMemUsed) {
        this.jvmMemUsed = jvmMemUsed;
    }

    @Pure
    public long getJvmMemTotal() {
        return this.jvmMemTotal;
    }

    public void setJvmMemTotal(long jvmMemTotal) {
        this.jvmMemTotal = jvmMemTotal;
    }

    @Pure
    public long getJvmMemFree() {
        return this.jvmMemFree;
    }

    public void setJvmMemFree(long jvmMemFree) {
        this.jvmMemFree = jvmMemFree;
    }

    @Pure
    public long getJvmMemMax() {
        return this.jvmMemMax;
    }

    public void setJvmMemMax(long jvmMemMax) {
        this.jvmMemMax = jvmMemMax;
    }

    @Pure
    public long getHeapMemUsed() {
        return this.heapMemUsed;
    }

    public void setHeapMemUsed(long heapMemUsed) {
        this.heapMemUsed = heapMemUsed;
    }

    @Pure
    public long getHeapMemMax() {
        return this.heapMemMax;
    }

    public void setHeapMemMax(long heapMemMax) {
        this.heapMemMax = heapMemMax;
    }

    @Pure
    public long getHeapMemCommitted() {
        return this.heapMemCommitted;
    }

    public void setHeapMemCommitted(long heapMemCommitted) {
        this.heapMemCommitted = heapMemCommitted;
    }

    @Pure
    public String getOsInfo() {
        return this.osInfo;
    }

    public void setOsInfo(String osInfo) {
        this.osInfo = osInfo;
    }

    @Pure
    public long getMemUsed() {
        return this.memUsed;
    }

    public void setMemUsed(long memUsed) {
        this.memUsed = memUsed;
    }

    @Pure
    public long getMemFree() {
        return this.memFree;
    }

    public void setMemFree(long memFree) {
        this.memFree = memFree;
    }

    @Pure
    public long getMemTotal() {
        return this.memTotal;
    }

    public void setMemTotal(long memTotal) {
        this.memTotal = memTotal;
    }

    @Pure
    public int getThreadTotalNum() {
        return this.threadTotalNum;
    }

    public void setThreadTotalNum(int threadTotalNum) {
        this.threadTotalNum = threadTotalNum;
    }

    @Pure
    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Pure
    public long getLoadedClassCount() {
        return this.loadedClassCount;
    }

    public void setLoadedClassCount(long loadedClassCount) {
        this.loadedClassCount = loadedClassCount;
    }

    @Pure
    public long getTotalloadedClassCount() {
        return this.totalloadedClassCount;
    }

    public void setTotalloadedClassCount(long totalloadedClassCount) {
        this.totalloadedClassCount = totalloadedClassCount;
    }

    @Pure
    public long getUnloadedClassCount() {
        return this.unloadedClassCount;
    }

    public void setUnloadedClassCount(long unloadedClassCount) {
        this.unloadedClassCount = unloadedClassCount;
    }

    @Pure
    public int getCpuTemp() {
        return this.cpuTemp;
    }

    public void setCpuTemp(int cpuTemp) {
        this.cpuTemp = cpuTemp;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("vmInfo", (Object)this.vmInfo);
        b.add("javaInfo", (Object)this.javaInfo);
        b.add("jvmMemUsed", (Object)this.jvmMemUsed);
        b.add("jvmMemTotal", (Object)this.jvmMemTotal);
        b.add("jvmMemFree", (Object)this.jvmMemFree);
        b.add("jvmMemMax", (Object)this.jvmMemMax);
        b.add("heapMemUsed", (Object)this.heapMemUsed);
        b.add("heapMemMax", (Object)this.heapMemMax);
        b.add("heapMemCommitted", (Object)this.heapMemCommitted);
        b.add("osInfo", (Object)this.osInfo);
        b.add("memUsed", (Object)this.memUsed);
        b.add("memFree", (Object)this.memFree);
        b.add("memTotal", (Object)this.memTotal);
        b.add("threadTotalNum", (Object)this.threadTotalNum);
        b.add("pid", (Object)this.pid);
        b.add("loadedClassCount", (Object)this.loadedClassCount);
        b.add("totalloadedClassCount", (Object)this.totalloadedClassCount);
        b.add("unloadedClassCount", (Object)this.unloadedClassCount);
        b.add("cpuTemp", (Object)this.cpuTemp);
        return b.toString();
    }
}

