/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.configure.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class ConfigureEntity {
  private MqttEntity mqtt = new MqttEntity();
  
  private RpcEntity rpc = new RpcEntity();
  
  private ObjectPoolEntity pool = new ObjectPoolEntity();
  
  private CacheEntity cache = new CacheEntity();
  
  private HostEntity ntp = new HostEntity("None", Integer.valueOf(123));
  
  @Pure
  public MqttEntity getMqtt() {
    return this.mqtt;
  }
  
  public void setMqtt(final MqttEntity mqtt) {
    this.mqtt = mqtt;
  }
  
  @Pure
  public RpcEntity getRpc() {
    return this.rpc;
  }
  
  public void setRpc(final RpcEntity rpc) {
    this.rpc = rpc;
  }
  
  @Pure
  public ObjectPoolEntity getPool() {
    return this.pool;
  }
  
  public void setPool(final ObjectPoolEntity pool) {
    this.pool = pool;
  }
  
  @Pure
  public CacheEntity getCache() {
    return this.cache;
  }
  
  public void setCache(final CacheEntity cache) {
    this.cache = cache;
  }
  
  @Pure
  public HostEntity getNtp() {
    return this.ntp;
  }
  
  public void setNtp(final HostEntity ntp) {
    this.ntp = ntp;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("mqtt", this.mqtt);
    b.add("rpc", this.rpc);
    b.add("pool", this.pool);
    b.add("cache", this.cache);
    b.add("ntp", this.ntp);
    return b.toString();
  }
}
