/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.crypto;

import cool.taomu.framework.utils.crypto.PgpUtils;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class SimplePgp implements ICrypto {
  private ICrypto c = null;
  
  private String key;
  
  private String password;
  
  private byte[] src;
  
  public SimplePgp(final byte[] src, final String publicKey) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.src = src;
    this.key = publicKey;
  }
  
  public SimplePgp(final byte[] src, final String privateKey, final String password) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.src = src;
    this.key = privateKey;
    this.password = password;
  }
  
  public SimplePgp(final ICrypto c, final String publicKey) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.c = c;
    this.key = publicKey;
  }
  
  public SimplePgp(final ICrypto c, final String privateKey, final String passwod) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.c = c;
    this.key = privateKey;
    this.password = this.password;
  }
  
  @Override
  public byte[] decode() {
    if ((this.c != null)) {
      byte[] bytes = PgpUtils.decrypt(this.c.getData(), this.key, this.password);
      this.c.setData(bytes);
      return this.c.decode();
    } else {
      return PgpUtils.decrypt(this.src, this.key, this.password);
    }
  }
  
  @Override
  public byte[] encode() {
    if ((this.c != null)) {
      return PgpUtils.encrypt(this.c.encode(), this.key, true);
    } else {
      return PgpUtils.encrypt(this.src, this.key, true);
    }
  }
  
  @Override
  public byte[] getData() {
    return this.src;
  }
  
  @Override
  public ICrypto setData(final byte[] src) {
    this.src = src;
    return this;
  }
  
  @Pure
  public ICrypto getC() {
    return this.c;
  }
  
  public void setC(final ICrypto c) {
    this.c = c;
  }
  
  @Pure
  public String getKey() {
    return this.key;
  }
  
  public void setKey(final String key) {
    this.key = key;
  }
  
  @Pure
  public String getPassword() {
    return this.password;
  }
  
  public void setPassword(final String password) {
    this.password = password;
  }
  
  @Pure
  public byte[] getSrc() {
    return this.src;
  }
  
  public void setSrc(final byte[] src) {
    this.src = src;
  }
}
