package cool.taomu.framework.crypto.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class LocalX509TrustManager implements X509TrustManager {
  private String filePath;
  
  @Override
  public void checkClientTrusted(final X509Certificate[] chain, final String authType) throws CertificateException {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
  
  @Override
  public void checkServerTrusted(final X509Certificate[] chain, final String authType) throws CertificateException {
    try {
      if ((chain == null)) {
        throw new CertificateException("");
      }
      int _length = chain.length;
      boolean _lessThan = (_length < 1);
      if (_lessThan) {
        throw new CertificateException("");
      }
      boolean _not = (!((authType != null) && authType.equals("ECDHE_RSA")));
      if (_not) {
        throw new CertificateException("");
      }
      TrustManagerFactory factory = TrustManagerFactory.getInstance("X509");
      factory.init(((KeyStore) null));
      final Consumer<TrustManager> _function = (TrustManager it) -> {
        try {
          ((X509TrustManager) it).checkServerTrusted(chain, authType);
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      ((List<TrustManager>)Conversions.doWrapArray(factory.getTrustManagers())).forEach(_function);
      CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
      File _file = new File("");
      FileInputStream input = new FileInputStream(_file);
      Certificate _generateCertificate = certificateFactory.generateCertificate(input);
      X509Certificate x509certificate = ((X509Certificate) _generateCertificate);
      byte[] _encoded = x509certificate.getPublicKey().getEncoded();
      String clientEncoded = new BigInteger(1, _encoded).toString(16);
      String clientSubject = x509certificate.getSubjectDN().getName();
      String clientIssUser = x509certificate.getIssuerDN().getName();
      X509Certificate certificate = chain[0];
      PublicKey publicKey = certificate.getPublicKey();
      byte[] _encoded_1 = publicKey.getEncoded();
      String serverEncoded = new BigInteger(1, _encoded_1).toString(16);
      boolean _equals = clientEncoded.equals(serverEncoded);
      boolean _not_1 = (!_equals);
      if (_not_1) {
        throw new CertificateException("");
      }
      boolean _equals_1 = clientSubject.equals(certificate.getSubjectDN().getName());
      boolean _not_2 = (!_equals_1);
      if (_not_2) {
        throw new CertificateException("");
      }
      boolean _equals_2 = clientIssUser.equals(certificate.getIssuerDN().getName());
      boolean _not_3 = (!_equals_2);
      if (_not_3) {
        throw new CertificateException("");
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public X509Certificate[] getAcceptedIssuers() {
    return Collections.<X509Certificate[]>unmodifiableList(CollectionLiterals.<X509Certificate[]>newArrayList()).get(0);
  }
}
