/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.crypto.ssl;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

@SuppressWarnings("all")
public class SslUtil {
  private KeyStore keyStore;
  
  public SslUtil(final String keyStoreType) {
    try {
      String _xifexpression = null;
      if ((keyStoreType == null)) {
        _xifexpression = "JKS";
      } else {
        _xifexpression = keyStoreType;
      }
      this.keyStore = KeyStore.getInstance(_xifexpression);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public TrustManagerFactory trustManageFactory() {
    try {
      TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
      tmf.init(this.keyStore);
      return tmf;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public TrustManagerFactory trustManageFactory(final String sslKeyFilePath, final String sslStorePwd) {
    try {
      FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
      this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
      final TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
      tmf.init(this.keyStore);
      return tmf;
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        return null;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public KeyManagerFactory keyManageFactory(final String sslKeyFilePath, final String sslManagerPwd, final String sslStorePwd) {
    try {
      FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
      this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
      final KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
      kmf.init(this.keyStore, sslManagerPwd.toCharArray());
      return kmf;
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        return null;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public SSLSocketFactory getSslSocketFactory() {
    try {
      SSLContext sslContext = SSLContext.getInstance("TLS");
      List<TrustManager> trustManagers = Collections.<TrustManager>unmodifiableList(CollectionLiterals.<TrustManager>newArrayList());
      final List<TrustManager> _converted_trustManagers = (List<TrustManager>)trustManagers;
      SecureRandom _secureRandom = new SecureRandom();
      sslContext.init(null, ((TrustManager[])Conversions.unwrapArray(_converted_trustManagers, TrustManager.class)), _secureRandom);
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void test() {
    Connection a = Jsoup.connect("");
  }
}
