/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.utils.crypto;

import cool.taomu.framework.crypto.Base64;
import java.io.File;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class PgpKeyTool {
  private static PGPKeyPair genKeyPair(final int rsaWidth) {
    try {
      KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
      kpg.initialize(rsaWidth);
      KeyPair kp = kpg.generateKeyPair();
      Date _date = new Date();
      return new JcaPGPKeyPair(PGPPublicKey.RSA_GENERAL, kp, _date);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static PGPSecretKey getSecretKey(final String identity, final String passPhrase, final int rsaWidth) {
    try {
      PGPKeyPair keyPair = PgpKeyTool.genKeyPair(rsaWidth);
      PGPDigestCalculator sha1Calc = new JcaPGPDigestCalculatorProviderBuilder().build().get(HashAlgorithmTags.SHA1);
      int _algorithm = keyPair.getPublicKey().getAlgorithm();
      JcaPGPContentSignerBuilder _jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(_algorithm, HashAlgorithmTags.SHA1);
      PBESecretKeyEncryptor _build = new JcePBESecretKeyEncryptorBuilder(PGPEncryptedData.CAST5, sha1Calc).setProvider("BC").build(
        passPhrase.toCharArray());
      return new PGPSecretKey(
        PGPSignature.DEFAULT_CERTIFICATION, keyPair, identity, sha1Calc, 
        null, 
        null, _jcaPGPContentSignerBuilder, _build);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static String getPrivateKey(final PGPSecretKey key) {
    try {
      byte[] _encoded = key.getEncoded();
      byte[] _encode = new Base64(_encoded).encode();
      Charset _forName = Charset.forName("UTF-8");
      return new String(_encode, _forName);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static String getPublicKey(final PGPSecretKey key) {
    try {
      PGPPublicKey pkey = key.getPublicKey();
      byte[] _encoded = pkey.getEncoded();
      byte[] _encode = new Base64(_encoded).encode();
      Charset _forName = Charset.forName("UTF-8");
      return new String(_encode, _forName);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void main(final String[] args) {
    try {
      BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
      Security.addProvider(_bouncyCastleProvider);
      PGPSecretKey skey = PgpKeyTool.getSecretKey("aaa", "123456789", 2048);
      File _file = new File("privateKey1.txt");
      FileUtils.writeStringToFile(_file, PgpKeyTool.getPrivateKey(skey), 
        Charset.forName("UTF-8"));
      File _file_1 = new File("publicKey1.txt");
      FileUtils.writeStringToFile(_file_1, PgpKeyTool.getPublicKey(skey), 
        Charset.forName("UTF-8"));
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
