package cool.taomu.framework.utils.reflect;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class CallSiteUtils {
  @Accessors
  public static class Mapping {
    private MethodHandle handle;
    
    private Class<?>[] parameterTypes;
    
    private Class<?> implZlass;
    
    @Pure
    public MethodHandle getHandle() {
      return this.handle;
    }
    
    public void setHandle(final MethodHandle handle) {
      this.handle = handle;
    }
    
    @Pure
    public Class<?>[] getParameterTypes() {
      return this.parameterTypes;
    }
    
    public void setParameterTypes(final Class<?>[] parameterTypes) {
      this.parameterTypes = parameterTypes;
    }
    
    @Pure
    public Class<?> getImplZlass() {
      return this.implZlass;
    }
    
    public void setImplZlass(final Class<?> implZlass) {
      this.implZlass = implZlass;
    }
  }
  
  private Class<?> inter;
  
  private static final Table<String, String, CallSiteUtils.Mapping> providers = HashBasedTable.<String, String, CallSiteUtils.Mapping>create();
  
  public CallSiteUtils(final Class<?> inter) {
    this.inter = inter;
  }
  
  public CallSiteUtils bind(final Class<?> src) {
    final Consumer<Method> _function = (Method i) -> {
      final Consumer<Method> _function_1 = (Method s) -> {
        try {
          boolean _equals = ImmutableList.<Class<?>>copyOf(((List<? extends Class<?>>)Conversions.doWrapArray(i.getParameterTypes()))).equals(ImmutableList.<Class<?>>copyOf(((List<? extends Class<?>>)Conversions.doWrapArray(s.getParameterTypes()))));
          if (_equals) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle mh = lookup.unreflect(s);
            MethodType type = mh.type();
            MethodType factoryType = MethodType.methodType(this.inter, type.parameterType(0));
            type = type.dropParameterTypes(0, 1);
            MethodHandle lam = LambdaMetafactory.metafactory(lookup, i.getName(), factoryType, type, mh, type).getTarget();
            CallSiteUtils.Mapping mapping = new CallSiteUtils.Mapping();
            mapping.handle = lam;
            mapping.implZlass = src;
            mapping.parameterTypes = type.parameterArray();
            String _name = i.getName();
            List<Class<?>> _immutableCopy = ImmutableList.<Class<?>>copyOf(((List<? extends Class<?>>)Conversions.doWrapArray(mapping.parameterTypes)));
            String _plus = (_name + _immutableCopy);
            CallSiteUtils.providers.put(_plus, s.getName(), mapping);
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      ((List<Method>)Conversions.doWrapArray(src.getDeclaredMethods())).forEach(_function_1);
    };
    ((List<Method>)Conversions.doWrapArray(this.inter.getDeclaredMethods())).forEach(_function);
    return this;
  }
  
  public Object bind(final Class<?> src, final Object... args) {
    try {
      String methodName = "";
      try {
        FunctionalInterface finterface = this.inter.<FunctionalInterface>getAnnotation(FunctionalInterface.class);
        final Method method = this.inter.getDeclaredMethods()[0];
        methodName = method.getName();
        if ((finterface != null)) {
          final Function1<Method, Boolean> _function = (Method it) -> {
            return Boolean.valueOf(ImmutableList.<Class<?>>copyOf(((List<? extends Class<?>>)Conversions.doWrapArray(it.getParameterTypes()))).equals(ImmutableList.<Class<?>>copyOf(((List<? extends Class<?>>)Conversions.doWrapArray(method.getParameterTypes())))));
          };
          Method bindMethod = IterableExtensions.<Method>findFirst(((Iterable<Method>)Conversions.doWrapArray(src.getDeclaredMethods())), _function);
          MethodHandles.Lookup lookup = MethodHandles.lookup();
          MethodHandle mh = lookup.unreflect(bindMethod);
          MethodType type = mh.type();
          MethodType factoryType = MethodType.methodType(this.inter, type.parameterType(0));
          type = type.dropParameterTypes(0, 1);
          MethodHandle handle = LambdaMetafactory.metafactory(lookup, method.getName(), factoryType, type, mh, type).getTarget();
          Object instance = handle.invoke(src.getConstructor(null).newInstance(null));
          return method.invoke(instance, args);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception e = (Exception)_t;
          throw new CodecGenerationException(("Could not generate the function to access the bind " + methodName), e);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Object invoke(final String methodName, final Object... args) {
    try {
      final Function1<Object, Class<?>> _function = (Object it) -> {
        return it.getClass();
      };
      List<Class<?>> argTypes = ListExtensions.<Object, Class<?>>map(ImmutableList.<Object>copyOf(((List<?>)Conversions.doWrapArray(args))), _function);
      CallSiteUtils.Mapping s = CallSiteUtils.providers.get((methodName + argTypes), methodName);
      final List<Class<?>> _converted_argTypes = (List<Class<?>>)argTypes;
      Method i = this.inter.getDeclaredMethod(methodName, ((Class<?>[])Conversions.unwrapArray(_converted_argTypes, Class.class)));
      Object o = s.implZlass.getConstructor(null).newInstance(null);
      Object instance = s.handle.invoke(o);
      return i.invoke(instance, args);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
