package cool.taomu.framework.utils.runtime;

import cool.taomu.framework.utils.ByteToSize;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class RuntimeInfo {
  private String vmInfo;
  
  private String javaInfo;
  
  private String jvmMemUsed;
  
  private String jvmMemTotal;
  
  private String jvmMemFree;
  
  private String jvmMemMax;
  
  private String heapMemUsed;
  
  private String heapMemMax;
  
  private String heapMemCommitted;
  
  private String osInfo;
  
  private String memUsed;
  
  private String memFree;
  
  private String memTotal;
  
  private int threadTotalNum;
  
  private String pid;
  
  private long loadedClassCount;
  
  private long totalloadedClassCount;
  
  private long unloadedClassCount;
  
  private int cpuTemp;
  
  private double sysCpuload;
  
  private double proCpuload;
  
  private int cpuCore;
  
  public RuntimeInfo() {
    try {
      long vmFree = 0;
      long vmUse = 0;
      long vmTotal = 0;
      long vmMax = 0;
      Runtime rt = Runtime.getRuntime();
      vmTotal = rt.totalMemory();
      vmFree = rt.freeMemory();
      vmMax = rt.maxMemory();
      vmUse = (vmTotal - vmFree);
      this.jvmMemFree = ByteToSize.sizeDescription(String.valueOf(vmFree));
      this.jvmMemUsed = ByteToSize.sizeDescription(String.valueOf(vmUse));
      this.jvmMemTotal = ByteToSize.sizeDescription(String.valueOf(vmTotal));
      this.jvmMemMax = ByteToSize.sizeDescription(String.valueOf(vmMax));
      OperatingSystemMXBean _operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
      com.sun.management.OperatingSystemMXBean osmxb = ((com.sun.management.OperatingSystemMXBean) _operatingSystemMXBean);
      String os = String.format("%s arch %s version %s", osmxb.getName(), osmxb.getArch(), osmxb.getVersion());
      this.sysCpuload = osmxb.getSystemCpuLoad();
      this.proCpuload = osmxb.getProcessCpuLoad();
      this.cpuCore = osmxb.getAvailableProcessors();
      long physicalFree = osmxb.getFreePhysicalMemorySize();
      long physicalTotal = osmxb.getTotalPhysicalMemorySize();
      long physicalUse = (physicalTotal - physicalFree);
      this.osInfo = os;
      boolean _contains = this.osInfo.contains("Linux");
      if (_contains) {
        InputStream temp = Runtime.getRuntime().exec("cat /sys/class/thermal/thermal_zone0/temp").getInputStream();
        String temp1 = IOUtils.toString(temp, "UTF-8");
        boolean _equals = temp1.equals("");
        if (_equals) {
          temp = Runtime.getRuntime().exec("cat /sys/class/hwmon/hwmon0/in0_input").getInputStream();
        }
        String temperature = IOUtils.toString(temp, "UTF-8").trim();
        boolean _equals_1 = temperature.equals("");
        boolean _not = (!_equals_1);
        if (_not) {
          int _parseInt = Integer.parseInt(temperature);
          int _divide = (_parseInt / 1000);
          this.cpuTemp = _divide;
        }
      }
      this.memFree = ByteToSize.sizeDescription(String.valueOf(physicalFree));
      this.memUsed = ByteToSize.sizeDescription(String.valueOf(physicalUse));
      this.memTotal = ByteToSize.sizeDescription(String.valueOf(physicalTotal));
      ThreadGroup parentThread = null;
      int totalThread = 0;
      for (parentThread = Thread.currentThread().getThreadGroup(); (parentThread.getParent() != 
        null); parentThread = parentThread.getParent()) {
        totalThread = parentThread.activeCount();
      }
      this.threadTotalNum = totalThread;
      this.pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
      RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
      this.vmInfo = String.format("%s version %s", runtime.getVmName(), runtime.getVmVersion());
      this.javaInfo = String.format("%s java version %s", runtime.getVmVendor(), System.getProperty("java.version"));
      ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
      this.loadedClassCount = cl.getLoadedClassCount();
      this.totalloadedClassCount = cl.getTotalLoadedClassCount();
      this.unloadedClassCount = cl.getUnloadedClassCount();
      MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
      this.heapMemUsed = ByteToSize.sizeDescription(String.valueOf(mem.getHeapMemoryUsage().getUsed()));
      this.heapMemMax = ByteToSize.sizeDescription(String.valueOf(mem.getHeapMemoryUsage().getMax()));
      this.heapMemCommitted = ByteToSize.sizeDescription(String.valueOf(mem.getHeapMemoryUsage().getCommitted()));
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void main(final String[] args) {
    RuntimeInfo a = new RuntimeInfo();
    InputOutput.<RuntimeInfo>println(a);
  }
  
  @Pure
  public String getVmInfo() {
    return this.vmInfo;
  }
  
  public void setVmInfo(final String vmInfo) {
    this.vmInfo = vmInfo;
  }
  
  @Pure
  public String getJavaInfo() {
    return this.javaInfo;
  }
  
  public void setJavaInfo(final String javaInfo) {
    this.javaInfo = javaInfo;
  }
  
  @Pure
  public String getJvmMemUsed() {
    return this.jvmMemUsed;
  }
  
  public void setJvmMemUsed(final String jvmMemUsed) {
    this.jvmMemUsed = jvmMemUsed;
  }
  
  @Pure
  public String getJvmMemTotal() {
    return this.jvmMemTotal;
  }
  
  public void setJvmMemTotal(final String jvmMemTotal) {
    this.jvmMemTotal = jvmMemTotal;
  }
  
  @Pure
  public String getJvmMemFree() {
    return this.jvmMemFree;
  }
  
  public void setJvmMemFree(final String jvmMemFree) {
    this.jvmMemFree = jvmMemFree;
  }
  
  @Pure
  public String getJvmMemMax() {
    return this.jvmMemMax;
  }
  
  public void setJvmMemMax(final String jvmMemMax) {
    this.jvmMemMax = jvmMemMax;
  }
  
  @Pure
  public String getHeapMemUsed() {
    return this.heapMemUsed;
  }
  
  public void setHeapMemUsed(final String heapMemUsed) {
    this.heapMemUsed = heapMemUsed;
  }
  
  @Pure
  public String getHeapMemMax() {
    return this.heapMemMax;
  }
  
  public void setHeapMemMax(final String heapMemMax) {
    this.heapMemMax = heapMemMax;
  }
  
  @Pure
  public String getHeapMemCommitted() {
    return this.heapMemCommitted;
  }
  
  public void setHeapMemCommitted(final String heapMemCommitted) {
    this.heapMemCommitted = heapMemCommitted;
  }
  
  @Pure
  public String getOsInfo() {
    return this.osInfo;
  }
  
  public void setOsInfo(final String osInfo) {
    this.osInfo = osInfo;
  }
  
  @Pure
  public String getMemUsed() {
    return this.memUsed;
  }
  
  public void setMemUsed(final String memUsed) {
    this.memUsed = memUsed;
  }
  
  @Pure
  public String getMemFree() {
    return this.memFree;
  }
  
  public void setMemFree(final String memFree) {
    this.memFree = memFree;
  }
  
  @Pure
  public String getMemTotal() {
    return this.memTotal;
  }
  
  public void setMemTotal(final String memTotal) {
    this.memTotal = memTotal;
  }
  
  @Pure
  public int getThreadTotalNum() {
    return this.threadTotalNum;
  }
  
  public void setThreadTotalNum(final int threadTotalNum) {
    this.threadTotalNum = threadTotalNum;
  }
  
  @Pure
  public String getPid() {
    return this.pid;
  }
  
  public void setPid(final String pid) {
    this.pid = pid;
  }
  
  @Pure
  public long getLoadedClassCount() {
    return this.loadedClassCount;
  }
  
  public void setLoadedClassCount(final long loadedClassCount) {
    this.loadedClassCount = loadedClassCount;
  }
  
  @Pure
  public long getTotalloadedClassCount() {
    return this.totalloadedClassCount;
  }
  
  public void setTotalloadedClassCount(final long totalloadedClassCount) {
    this.totalloadedClassCount = totalloadedClassCount;
  }
  
  @Pure
  public long getUnloadedClassCount() {
    return this.unloadedClassCount;
  }
  
  public void setUnloadedClassCount(final long unloadedClassCount) {
    this.unloadedClassCount = unloadedClassCount;
  }
  
  @Pure
  public int getCpuTemp() {
    return this.cpuTemp;
  }
  
  public void setCpuTemp(final int cpuTemp) {
    this.cpuTemp = cpuTemp;
  }
  
  @Pure
  public double getSysCpuload() {
    return this.sysCpuload;
  }
  
  public void setSysCpuload(final double sysCpuload) {
    this.sysCpuload = sysCpuload;
  }
  
  @Pure
  public double getProCpuload() {
    return this.proCpuload;
  }
  
  public void setProCpuload(final double proCpuload) {
    this.proCpuload = proCpuload;
  }
  
  @Pure
  public int getCpuCore() {
    return this.cpuCore;
  }
  
  public void setCpuCore(final int cpuCore) {
    this.cpuCore = cpuCore;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("vmInfo", this.vmInfo);
    b.add("javaInfo", this.javaInfo);
    b.add("jvmMemUsed", this.jvmMemUsed);
    b.add("jvmMemTotal", this.jvmMemTotal);
    b.add("jvmMemFree", this.jvmMemFree);
    b.add("jvmMemMax", this.jvmMemMax);
    b.add("heapMemUsed", this.heapMemUsed);
    b.add("heapMemMax", this.heapMemMax);
    b.add("heapMemCommitted", this.heapMemCommitted);
    b.add("osInfo", this.osInfo);
    b.add("memUsed", this.memUsed);
    b.add("memFree", this.memFree);
    b.add("memTotal", this.memTotal);
    b.add("threadTotalNum", this.threadTotalNum);
    b.add("pid", this.pid);
    b.add("loadedClassCount", this.loadedClassCount);
    b.add("totalloadedClassCount", this.totalloadedClassCount);
    b.add("unloadedClassCount", this.unloadedClassCount);
    b.add("cpuTemp", this.cpuTemp);
    b.add("sysCpuload", this.sysCpuload);
    b.add("proCpuload", this.proCpuload);
    b.add("cpuCore", this.cpuCore);
    return b.toString();
  }
}
