/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.crypto;

import cool.taomu.framework.crypto.ICrypto;
import cool.taomu.framework.utils.crypto.PgpUtils;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SimplePgp
implements ICrypto {
    private ICrypto c = null;
    private String key;
    private String password;
    private byte[] src;

    public SimplePgp(byte[] src, String publicKey) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.src = src;
        this.key = publicKey;
    }

    public SimplePgp(byte[] src, String privateKey, String password) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.src = src;
        this.key = privateKey;
        this.password = password;
    }

    public SimplePgp(ICrypto c, String publicKey) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.c = c;
        this.key = publicKey;
    }

    public SimplePgp(ICrypto c, String privateKey, String passwod) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.c = c;
        this.key = privateKey;
        this.password = this.password;
    }

    @Override
    public byte[] decode() {
        if (this.c != null) {
            byte[] bytes = PgpUtils.decrypt(this.c.getData(), this.key, this.password);
            this.c.setData(bytes);
            return this.c.decode();
        }
        return PgpUtils.decrypt(this.src, this.key, this.password);
    }

    @Override
    public byte[] encode() {
        if (this.c != null) {
            return PgpUtils.encrypt(this.c.encode(), this.key, true);
        }
        return PgpUtils.encrypt(this.src, this.key, true);
    }

    @Override
    public byte[] getData() {
        return this.src;
    }

    @Override
    public ICrypto setData(byte[] src) {
        this.src = src;
        return this;
    }

    @Pure
    public ICrypto getC() {
        return this.c;
    }

    public void setC(ICrypto c) {
        this.c = c;
    }

    @Pure
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Pure
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Pure
    public byte[] getSrc() {
        return this.src;
    }

    public void setSrc(byte[] src) {
        this.src = src;
    }
}

