/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils.spi;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cool.taomu.framework.utils.reflect.ReflectUtils;
import cool.taomu.framework.utils.spi.Alias;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoader<S> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLoader.class);
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final String name;
    private final ClassLoader loader;
    private Object[] args;
    private static final Table<String, String, Class<?>> providers = HashBasedTable.create();

    private void loadZlass() {
        try {
            String _name = this.service.getName();
            String fullName = PREFIX + _name;
            Enumeration<URL> configs = null;
            configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
            this.loadZlass(configs);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void loadZlass(Enumeration<URL> configs) {
        try {
            while (configs.hasMoreElements()) {
                String path = configs.nextElement().toString();
                LOG.info(path);
                String _replace = path.replace("file:", "");
                File _file = new File(_replace);
                String strings = FileUtils.readFileToString((File)_file, (String)"UTF-8");
                Consumer<String> _function = it -> {
                    boolean _not;
                    Class<?> zlass = null;
                    try {
                        zlass = Class.forName(it, false, this.loader);
                        Alias alias = zlass.getAnnotation(Alias.class);
                        if (alias != null && !alias.value().equals("")) {
                            providers.put((Object)this.name, (Object)alias.value(), zlass);
                        } else {
                            providers.put((Object)this.name, (Object)zlass.getSimpleName(), zlass);
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ClassNotFoundException) {
                            ClassNotFoundException ex = (ClassNotFoundException)_t;
                            LOG.info("\u7c7b " + it + " \u4e0d\u5b58\u5728", (Throwable)ex);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    boolean _isAssignableFrom = this.service.isAssignableFrom(zlass);
                    boolean bl = _not = !_isAssignableFrom;
                    if (_not) {
                        LOG.info("\u7c7b" + it + " \u4e0d\u662f " + this.name + " subtype");
                    }
                };
                IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)strings.split("\n")))).forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private ServiceLoader(Class<S> svc, ClassLoader cl, boolean isReload, Object ... args) {
        this.service = Objects.requireNonNull(svc, "class \u4e0d\u80fd\u4e3a null");
        this.name = svc.getName();
        this.loader = (ClassLoader)ObjectUtils.defaultIfNull((Object)cl, (Object)ClassLoader.getSystemClassLoader());
        if (isReload) {
            providers.row((Object)this.name).clear();
        }
        this.loadZlass();
        this.args = args;
    }

    public S get(String key) {
        Object obj = ReflectUtils.newInstance(this.getZlass(key), this.args);
        return this.service.cast(obj);
    }

    public S get(Integer index) {
        boolean _equals;
        Collection pro = providers.row((Object)this.name).values();
        int _size = pro.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return null;
        }
        Object obj = ReflectUtils.newInstance(((Class[])Conversions.unwrapArray(providers.row((Object)this.name).values(), Class.class))[index], this.args);
        return this.service.cast(obj);
    }

    public Iterable<S> get() {
        Set keySet = providers.row((Object)this.name).keySet();
        Functions.Function1 _function = it -> this.service.cast(ReflectUtils.newInstance((Class)providers.get((Object)this.name, it), this.args));
        return IterableExtensions.map(keySet, (Functions.Function1)_function);
    }

    public Class<?> getZlass(String key) {
        return (Class)providers.get((Object)this.name, (Object)key);
    }

    public S first() {
        return this.get(0);
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader, Object ... args) {
        return new ServiceLoader<S>(service, loader, false, args);
    }

    public static <S> ServiceLoader<S> load(Class<S> service, Object ... args) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader(), args);
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader(), null);
    }

    public static <S> ServiceLoader<S> reload(Class<S> service, ClassLoader loader, Object ... args) {
        return new ServiceLoader<S>(service, loader, true, args);
    }

    public static <S> ServiceLoader<S> reload(Class<S> service, Object ... args) {
        return ServiceLoader.reload(service, Thread.currentThread().getContextClassLoader(), args);
    }
}

