/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.asm.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.objectweb.asm.Opcodes;

@Accessors
@ToString
@SuppressWarnings("all")
public class MethodEntity {
  private int access = Opcodes.ACC_PUBLIC;
  
  private String internalName;
  
  private String defineMethod;
  
  private boolean defaultPackage = false;
  
  public MethodEntity(final String defineMethod) {
    this(defineMethod, false);
  }
  
  public MethodEntity(final String defineMethod, final boolean defaultPackage) {
    this.defaultPackage = defaultPackage;
    this.defineMethod = defineMethod;
  }
  
  public MethodEntity(final String internalName, final String defineMethod) {
    this.defineMethod = defineMethod;
    this.internalName = internalName;
  }
  
  public MethodEntity(final String internalName, final String defineMethod, final boolean defaultPackage) {
    this.defaultPackage = defaultPackage;
    this.defineMethod = defineMethod;
    this.internalName = internalName;
  }
  
  @Pure
  public int getAccess() {
    return this.access;
  }
  
  public void setAccess(final int access) {
    this.access = access;
  }
  
  @Pure
  public String getInternalName() {
    return this.internalName;
  }
  
  public void setInternalName(final String internalName) {
    this.internalName = internalName;
  }
  
  @Pure
  public String getDefineMethod() {
    return this.defineMethod;
  }
  
  public void setDefineMethod(final String defineMethod) {
    this.defineMethod = defineMethod;
  }
  
  @Pure
  public boolean isDefaultPackage() {
    return this.defaultPackage;
  }
  
  public void setDefaultPackage(final boolean defaultPackage) {
    this.defaultPackage = defaultPackage;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("access", this.access);
    b.add("internalName", this.internalName);
    b.add("defineMethod", this.defineMethod);
    b.add("defaultPackage", this.defaultPackage);
    return b.toString();
  }
}
