package cool.taomu.guice;

import cool.taomu.asm.CreateMethod;
import cool.taomu.asm.entity.MethodEntity;
import cool.taomu.guice.ann.Binder;
import cool.taomu.guice.ann.Scope;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.objectweb.asm.Type;

@SuppressWarnings("all")
public class BinderRule {
  public static void rule(final CreateMethod cm, final Binder[] binders) {
    final MethodEntity bind = new MethodEntity("com/google/inject/Binder", 
      "com/google/inject/binder/AnnotatedBindingBuilder bind(java/lang/Class)", true);
    final MethodEntity to = new MethodEntity("com/google/inject/binder/AnnotatedBindingBuilder", 
      "com/google/inject/binder/ScopedBindingBuilder to(java/lang/Class)", true);
    final MethodEntity in = new MethodEntity("com/google/inject/binder/ScopedBindingBuilder", "void in(com/google/inject/Scope)", 
      true);
    final Consumer<Binder> _function = (Binder it) -> {
      boolean _equals = it.bind().equals(Void.class);
      boolean _not = (!_equals);
      if (_not) {
        cm.load("binder").ldc(Type.getType(it.bind())).invokeInterface(bind);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.named());
        boolean _not_1 = (!_isNullOrEmpty);
        if (_not_1) {
          cm.ldc(it.named());
          MethodEntity _methodEntity = new MethodEntity("com/google/inject/name/Names", 
            "com/google/inject/name/Named named(java/lang/String)", true);
          cm.invokeStatic(_methodEntity);
          MethodEntity _methodEntity_1 = new MethodEntity("com/google/inject/binder/AnnotatedBindingBuilder", 
            "com/google/inject/binder/LinkedBindingBuilder annotatedWith(java/lang/annotation/Annotation)", 
            true);
          cm.invokeInterface(_methodEntity_1);
        }
        boolean _equals_1 = it.to().equals(Void.class);
        boolean _not_2 = (!_equals_1);
        if (_not_2) {
          cm.ldc(Type.getType(it.to())).invokeInterface(to);
          Scope _in = it.in();
          boolean _tripleNotEquals = (_in != Scope.None);
          if (_tripleNotEquals) {
            boolean _equals_2 = it.in().equals(Scope.SINGLETON);
            if (_equals_2) {
              cm.getStatic("com/google/inject/Scopes", "SINGLETON", "Lcom/google/inject/Scope;");
            } else {
              boolean _equals_3 = it.in().equals(Scope.NO_SCOPE);
              if (_equals_3) {
                cm.getStatic("com/google/inject/Scopes", "NO_SCOPE", "Lcom/google/inject/Scope;");
              }
            }
            cm.invokeInterface(in);
          } else {
            cm.pop();
          }
        } else {
          boolean _equals_4 = it.instance().equals(Void.class);
          boolean _not_3 = (!_equals_4);
          if (_not_3) {
            cm.store("instance", Binder.class);
            cm.NEW(it.instance());
            cm.dup();
            final ArrayList<String> vinit = CollectionLiterals.<String>newArrayList(new String[] { "void", " <init>(" });
            final Consumer<Binder.Args> _function_1 = (Binder.Args arg) -> {
              boolean _equals_5 = arg.type().equals(Class.class);
              if (_equals_5) {
                cm.ldc(Type.getType(arg.classval()));
                vinit.add("Class,");
              } else {
                boolean _equals_6 = arg.type().equals(String.class);
                if (_equals_6) {
                  cm.ldc(arg.strval());
                  vinit.add("String,");
                } else {
                  boolean _equals_7 = arg.type().equals(char.class);
                  if (_equals_7) {
                    cm.ldc(Character.valueOf(arg.charval()));
                    vinit.add("char,");
                  } else {
                    boolean _equals_8 = arg.type().equals(int.class);
                    if (_equals_8) {
                      cm.ldc(Integer.valueOf(arg.intval()));
                      vinit.add("int,");
                    } else {
                      boolean _equals_9 = arg.type().equals(short.class);
                      if (_equals_9) {
                        cm.ldc(Short.valueOf(arg.shortval()));
                        vinit.add("short,");
                      } else {
                        boolean _equals_10 = arg.type().equals(long.class);
                        if (_equals_10) {
                          cm.ldc(Long.valueOf(arg.longval()));
                          vinit.add("long,");
                        } else {
                          boolean _equals_11 = arg.type().equals(double.class);
                          if (_equals_11) {
                            cm.ldc(Double.valueOf(arg.doubleval()));
                            vinit.add("double,");
                          } else {
                            boolean _equals_12 = arg.type().equals(float.class);
                            if (_equals_12) {
                              cm.ldc(Float.valueOf(arg.floatval()));
                              vinit.add("float,");
                            } else {
                              boolean _equals_13 = arg.type().equals(boolean.class);
                              if (_equals_13) {
                                cm.ldc(Boolean.valueOf(arg.boolval()));
                                vinit.add("boolean,");
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            };
            IterableExtensions.<Binder.Args>filterNull(((Iterable<Binder.Args>)Conversions.doWrapArray(it.args()))).forEach(_function_1);
            String _join = IterableExtensions.join(((Iterable<?>)Conversions.doWrapArray(IterableExtensions.join(vinit, "").split(","))), ",");
            String init = (_join + ")");
            String _name = it.instance().getName();
            MethodEntity _methodEntity_2 = new MethodEntity(_name, init);
            cm.invokeSpecial(_methodEntity_2);
            cm.store(it.instance().getName(), it.instance());
            cm.load("instance");
            cm.load(it.instance().getName());
            MethodEntity _methodEntity_3 = new MethodEntity("com/google/inject/binder/AnnotatedBindingBuilder", 
              "void toInstance(java/lang/Object)", true);
            cm.invokeInterface(_methodEntity_3);
          }
        }
      }
    };
    IterableExtensions.<Binder>filterNull(((Iterable<Binder>)Conversions.doWrapArray(binders))).forEach(_function);
  }
}
