/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.guice;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import cool.taomu.asm.CreateClass;
import cool.taomu.asm.CreateMethod;
import cool.taomu.asm.entity.ClassEntity;
import cool.taomu.asm.entity.MethodEntity;
import cool.taomu.guice.ann.Binder;
import cool.taomu.guice.ann.Binders;
import cool.taomu.guice.ann.BindersImpl;
import cool.taomu.guice.ann.Box;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TaomuGuice {
  private static final Logger LOG = LoggerFactory.getLogger(TaomuGuice.class);
  
  private static final ConcurrentSkipListMap<String, Injector> cacheInjector = new ConcurrentSkipListMap<String, Injector>();
  
  private static final ConcurrentSkipListMap<String, Class<? extends com.google.inject.Module>> cacheModule = new ConcurrentSkipListMap<String, Class<? extends com.google.inject.Module>>();
  
  private static final ConcurrentSkipListMap<String, Binders> cacheBinders = new ConcurrentSkipListMap<String, Binders>();
  
  public static Injector entry(final Class<?> zlass) throws CreationException {
    return TaomuGuice.entry("default", false, zlass);
  }
  
  public static Injector entry(final String name, final Class<?> zlass) throws CreationException {
    return TaomuGuice.entry(name, false, zlass);
  }
  
  public static Injector entry(final String name, final boolean isDebug, final Class<?> zlass) throws CreationException {
    try {
      String key = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(name)), "<=>");
      boolean _containsKey = TaomuGuice.cacheInjector.containsKey(key);
      if (_containsKey) {
        return TaomuGuice.cacheInjector.get(key);
      } else {
        final Box box = zlass.<Box>getAnnotation(Box.class);
        final Binders binders = zlass.<Binders>getAnnotation(Binders.class);
        final Binder binder = zlass.<Binder>getAnnotation(Binder.class);
        if ((box != null)) {
          final Consumer<Binders> _function = (Binders it) -> {
            TaomuGuice.LOG.info("box name:{}", it.name());
            boolean _containsKey_1 = TaomuGuice.cacheBinders.containsKey(it.name());
            boolean _not = (!_containsKey_1);
            if (_not) {
              TaomuGuice.cacheBinders.put(it.name(), it);
            }
          };
          ((List<Binders>)Conversions.doWrapArray(box.value())).forEach(_function);
        } else {
          if ((binders != null)) {
            TaomuGuice.LOG.info("name:{}", binders.name());
            boolean _containsKey_1 = TaomuGuice.cacheBinders.containsKey(binders.name());
            boolean _not = (!_containsKey_1);
            if (_not) {
              TaomuGuice.cacheBinders.put(binders.name(), binders);
            }
          } else {
            if ((binder != null)) {
              boolean _containsKey_2 = TaomuGuice.cacheBinders.containsKey("default");
              boolean _not_1 = (!_containsKey_2);
              if (_not_1) {
                BindersImpl _bindersImpl = new BindersImpl("default", new Binder[] { binder });
                TaomuGuice.cacheBinders.put("default", _bindersImpl);
              }
            }
          }
        }
        int _size = TaomuGuice.cacheBinders.size();
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          final Consumer<Binders> _function_1 = (Binders it) -> {
            boolean _containsKey_3 = TaomuGuice.cacheModule.containsKey(it.name());
            boolean _not_2 = (!_containsKey_3);
            if (_not_2) {
              TaomuGuice.LOG.info("build :{}", it.name());
              TaomuGuice.cacheModule.put(it.name(), TaomuGuice.buildModule(it, isDebug));
            }
          };
          TaomuGuice.cacheBinders.values().forEach(_function_1);
        }
        TaomuGuice.LOG.info("key:{}", key);
        Class<? extends com.google.inject.Module> module = TaomuGuice.cacheModule.get(key);
        Injector injector = Guice.createInjector(module.newInstance());
        return TaomuGuice.cacheInjector.getOrDefault(key, injector);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Class<? extends com.google.inject.Module> buildModule(final Binders binders, final boolean isDebug) {
    try {
      if ((binders != null)) {
        String name = UUID.randomUUID().toString().replace("-", "");
        String moduleName = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("Taomu", name, "Module")), "");
        ClassEntity classEntity = new ClassEntity("cool.taomu.guice", moduleName);
        classEntity.setSuperclass(Type.getType(AbstractModule.class).getInternalName());
        CreateClass cc = CreateClass.Class(classEntity, Opcodes.V1_8, isDebug);
        cc.constructor(AbstractModule.class.getConstructors());
        MethodEntity methodEntity = new MethodEntity("void configure()");
        MethodEntity binder = new MethodEntity("com/google/inject/Binder binder()", true);
        final CreateMethod cm = cc.method(methodEntity).This().invokeVirtual(binder).store("binder", com.google.inject.Binder.class);
        boolean _equals = binders.properties().equals("");
        boolean _not = (!_equals);
        if (_not) {
          cm.load("binder");
          cm.ldc(binders.properties());
          MethodEntity _methodEntity = new MethodEntity("cool/taomu/util/PropertyUtils", 
            "java/util/Properties load(java/lang/String)", true);
          cm.invokeStatic(_methodEntity);
          MethodEntity _methodEntity_1 = new MethodEntity("com/google/inject/name/Names", 
            "void bindProperties(com/google/inject/Binder,java/util/Properties)", true);
          cm.invokeStatic(_methodEntity_1);
        }
        final Consumer<String> _function = (String it) -> {
          TaomuGuice.LOG.info("dependence");
          boolean _containsKey = TaomuGuice.cacheModule.containsKey(it);
          if (_containsKey) {
            Class<? extends com.google.inject.Module> m = TaomuGuice.cacheModule.get(it);
            cm.ldc(m.getName());
            MethodEntity _methodEntity_2 = new MethodEntity("cool/taomu/asm/CreateClass", "java/lang/Class loadZlass(java/lang/String)", 
              true);
            cm.invokeStatic(_methodEntity_2);
            MethodEntity _methodEntity_3 = new MethodEntity("java/lang/Class", "java/lang/Object newInstance()", true);
            cm.invokeVirtual(_methodEntity_3);
            cm.store("cmodule", Object.class);
            cm.load("binder");
            cm.load("cmodule");
            cm.checkCast(com.google.inject.Module.class);
            MethodEntity _methodEntity_4 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
            cm.invokeInterface(_methodEntity_4);
          } else {
            boolean _containsKey_1 = TaomuGuice.cacheBinders.containsKey(it);
            if (_containsKey_1) {
              Binders bs = TaomuGuice.cacheBinders.get(it);
              TaomuGuice.cacheModule.put(bs.name(), TaomuGuice.buildModule(bs, isDebug));
              cm.ldc(bs.name());
              MethodEntity _methodEntity_5 = new MethodEntity("cool/taomu/asm/CreateClass", "java/lang/Class loadZlass(java/lang/String)", 
                true);
              cm.invokeStatic(_methodEntity_5);
              MethodEntity _methodEntity_6 = new MethodEntity("java/lang/Class", "java/lang/Object newInstance()", true);
              cm.invokeVirtual(_methodEntity_6);
              cm.store("cmodule", Object.class);
              cm.load("binder");
              cm.load("cmodule");
              cm.checkCast(com.google.inject.Module.class);
              MethodEntity _methodEntity_7 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
              cm.invokeInterface(_methodEntity_7);
            }
          }
        };
        IterableExtensions.<String>filterNull(((Iterable<String>)Conversions.doWrapArray(binders.dependence()))).forEach(_function);
        final Consumer<Class<? extends com.google.inject.Module>> _function_1 = (Class<? extends com.google.inject.Module> it) -> {
          cm.NEW(it);
          cm.dup();
          String _name = it.getName();
          MethodEntity _methodEntity_2 = new MethodEntity(_name, "void <init>()");
          cm.invokeSpecial(_methodEntity_2);
          cm.store(it.getName(), it);
          cm.load("binder");
          cm.load(it.getName());
          MethodEntity _methodEntity_3 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
          cm.invokeInterface(_methodEntity_3);
        };
        IterableExtensions.<Class<? extends com.google.inject.Module>>filterNull(((Iterable<Class<? extends com.google.inject.Module>>)Conversions.doWrapArray(binders.installs()))).forEach(_function_1);
        BinderRule.rule(cm, binders.value());
        cm.returnValue().endMethod();
        cc.end();
        TaomuGuice.LOG.info("end");
        Class<?> _loadClass = cc.loadClass(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("cool.taomu.guice", moduleName)), "."));
        return ((Class<com.google.inject.Module>) _loadClass);
      }
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
