/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.asm;

import com.google.common.base.Objects;
import cool.taomu.asm.entity.ClassEntity;
import cool.taomu.asm.entity.FieldEntity;
import cool.taomu.asm.entity.MethodEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Accessors
public class CreateMethod {
    private GeneratorAdapter ga;
    private ClassEntity classEntity;
    private String internalName;
    private final ConcurrentHashMap<String, Variable> localVariable = new ConcurrentHashMap();

    public CreateMethod(ClassEntity classEntity, GeneratorAdapter ga) {
        this.ga = ga;
        this.classEntity = classEntity;
        String _packageName = classEntity.getPackageName();
        String _className = classEntity.getClassName();
        this.internalName = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_packageName, _className})), (CharSequence)".");
    }

    public CreateMethod invokeVirtual(MethodEntity method) {
        boolean _not;
        String internalName = this.internalName.replace(".", "/");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)method.getInternalName());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            internalName = method.getInternalName();
        }
        this.ga.invokeVirtual(Type.getObjectType((String)internalName), Method.getMethod((String)method.getDefineMethod(), (boolean)method.isDefaultPackage()));
        return this;
    }

    public CreateMethod invokeInterface(MethodEntity method) {
        this.ga.invokeInterface(Type.getObjectType((String)method.getInternalName().replace(".", "/")), Method.getMethod((String)method.getDefineMethod(), (boolean)method.isDefaultPackage()));
        return this;
    }

    public CreateMethod invokeStatic(MethodEntity method) {
        this.ga.invokeStatic(Type.getObjectType((String)method.getInternalName().replace(".", "/")), Method.getMethod((String)method.getDefineMethod(), (boolean)method.isDefaultPackage()));
        return this;
    }

    public CreateMethod invokeSpecial(MethodEntity method) {
        this.ga.invokeConstructor(Type.getObjectType((String)method.getInternalName().replace(".", "/")), Method.getMethod((String)method.getDefineMethod(), (boolean)method.isDefaultPackage()));
        return this;
    }

    public CreateMethod getStatic(String internalName, String name, String type) {
        this.ga.getStatic(Type.getObjectType((String)internalName.replace(".", "/")), name, Type.getType((String)type));
        return this;
    }

    public CreateMethod getField(FieldEntity field) {
        this.ga.loadThis();
        this.ga.getField(Type.getObjectType((String)this.internalName.replace(".", "/")), field.getName(), Type.getType((String)field.getDescriptor()));
        return this;
    }

    public CreateMethod setField(FieldEntity field, Instruct is) {
        this.ga.loadThis();
        if (is != null) {
            is.coding(this);
        }
        this.ga.putField(Type.getObjectType((String)this.internalName.replace(".", "/")), field.getName(), Type.getType((String)field.getDescriptor()));
        return this;
    }

    public CreateMethod store(String name, Class<?> zlass) {
        Type type = Type.getType(zlass);
        int index = this.ga.newLocal(type);
        this.ga.storeLocal(index, type);
        Type _type = Type.getType(zlass);
        Variable _variable = new Variable(index, _type);
        this.localVariable.put(name, _variable);
        return this;
    }

    public CreateMethod load(String name) {
        boolean _containsKey = this.localVariable.containsKey(name);
        if (_containsKey) {
            Variable local = this.localVariable.get(name);
            this.ga.loadLocal(local.index.intValue(), local.type);
        }
        return this;
    }

    public CreateMethod This() {
        this.ga.loadThis();
        return this;
    }

    public CreateMethod pop() {
        this.ga.pop();
        return this;
    }

    protected CreateMethod _ldc(Type type) {
        this.ga.push(type);
        return this;
    }

    protected CreateMethod _ldc(String value) {
        this.ga.push(value);
        return this;
    }

    protected CreateMethod _ldc(int value) {
        this.ga.push(value);
        return this;
    }

    protected CreateMethod _ldc(long value) {
        this.ga.push(value);
        return this;
    }

    protected CreateMethod _ldc(short value) {
        this.ga.push((int)value);
        return this;
    }

    protected CreateMethod _ldc(double value) {
        this.ga.push(value);
        return this;
    }

    protected CreateMethod _ldc(float value) {
        this.ga.push(value);
        return this;
    }

    protected CreateMethod _ldc(boolean value) {
        this.ga.push(value);
        return this;
    }

    protected CreateMethod _ldc(char value) {
        this.ga.push((int)value);
        return this;
    }

    public CreateMethod NEW(Class<?> zlass) {
        this.ga.newInstance(Type.getType(zlass));
        return this;
    }

    public CreateMethod dup() {
        this.ga.dup();
        return this;
    }

    public CreateMethod returnValue() {
        this.ga.returnValue();
        return this;
    }

    public CreateMethod endMethod() {
        this.ga.endMethod();
        return this;
    }

    public CreateMethod checkCast(Class<?> type) {
        this.ga.checkCast(Type.getType(type));
        return this;
    }

    public CreateMethod invokeVirtual(Class<?> zlass, String method) {
        return this.invokeVirtual(zlass.getName(), method);
    }

    public CreateMethod invokeVirtual(String internalName, String method) {
        return this.invokeVirtual(internalName, method, true);
    }

    public CreateMethod invokeVirtual(String internalName, String method, boolean defaultPackage) {
        this.ga.invokeVirtual(Type.getObjectType((String)internalName.replace(".", "/")), Method.getMethod((String)method, (boolean)defaultPackage));
        return this;
    }

    public CreateMethod buildReturnValue(java.lang.reflect.Method m) {
        Class<?> _returnType = m.getReturnType();
        boolean _matched = false;
        if (Objects.equal(_returnType, Integer.TYPE)) {
            _matched = true;
            this.checkCast(Integer.class);
            this.invokeVirtual(Integer.class, "int intValue()");
        }
        if (!_matched && Objects.equal(_returnType, Long.TYPE)) {
            _matched = true;
            this.checkCast(Long.class);
            this.invokeVirtual(Long.class, "long longValue()");
        }
        if (!_matched && Objects.equal(_returnType, Double.TYPE)) {
            _matched = true;
            this.checkCast(Double.class);
            this.invokeVirtual(Double.class, "double doubleValue()");
        }
        if (!_matched && Objects.equal(_returnType, Float.TYPE)) {
            _matched = true;
            this.checkCast(Float.class);
            this.invokeVirtual(Float.class, "float floatValue()");
        }
        if (!_matched && Objects.equal(_returnType, Boolean.TYPE)) {
            _matched = true;
            this.checkCast(Boolean.class);
            this.invokeVirtual(Boolean.class, "boolean booleanValue()");
        }
        if (!_matched && Objects.equal(_returnType, Short.TYPE)) {
            _matched = true;
            this.checkCast(Short.class);
            this.invokeVirtual(Short.class, "short shortValue()");
        }
        if (!_matched && Objects.equal(_returnType, Character.TYPE)) {
            _matched = true;
            this.checkCast(Character.class);
            this.invokeVirtual(Character.class, "char charValue()");
        }
        if (!_matched && Objects.equal(_returnType, Byte.TYPE)) {
            _matched = true;
            this.checkCast(Byte.class);
            this.invokeVirtual(Byte.class, "byte byteValue()");
        }
        if (!_matched && Objects.equal(_returnType, Void.TYPE)) {
            _matched = true;
        }
        if (!_matched) {
            this.checkCast(m.getReturnType());
        }
        return this;
    }

    public CreateMethod buildArguments(Method method) {
        boolean _greaterThan;
        int _size = ((List)Conversions.doWrapArray((Object)method.getArgumentTypes())).size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            for (int index = 0; index < ((List)Conversions.doWrapArray((Object)method.getArgumentTypes())).size(); ++index) {
                this.ga.dup();
                this.ga.push(index);
                String _descriptor = method.getArgumentTypes()[index].getDescriptor();
                if (_descriptor != null) {
                    switch (_descriptor) {
                        case "Z": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Boolean.class, "Boolean valueOf(boolean)");
                            break;
                        }
                        case "C": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Character.class, "Character valueOf(char)");
                            break;
                        }
                        case "B": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Byte.class, "Byte valueOf(byte)");
                            break;
                        }
                        case "S": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Short.class, "Short valueOf(short)");
                            break;
                        }
                        case "I": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Integer.class, "Integer valueOf(int)");
                            break;
                        }
                        case "F": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Float.class, "Float valueOf(float)");
                            break;
                        }
                        case "J": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Float.class, "Long valueOf(long)");
                            break;
                        }
                        case "D": {
                            this.ga.loadArg(index);
                            this.invokeStatic(Float.class, "Double valueOf(double)");
                            break;
                        }
                        default: {
                            this.ga.visitVarInsn(25, index + 1);
                            break;
                        }
                    }
                } else {
                    this.ga.visitVarInsn(25, index + 1);
                }
                this.ga.visitInsn(83);
            }
        } else {
            this.ga.visitInsn(1);
        }
        return this;
    }

    public CreateMethod invokeStatic(Class<?> type, String method) {
        return this.invokeStatic(type.getName(), method, true);
    }

    public CreateMethod invokeStatic(String internalName, String method, boolean defaultPackage) {
        this.ga.invokeStatic(Type.getObjectType((String)internalName.replace(".", "/")), Method.getMethod((String)method, (boolean)defaultPackage));
        return this;
    }

    public CreateMethod ldc(Object value) {
        if (value instanceof Double) {
            return this._ldc((Double)value);
        }
        if (value instanceof Float) {
            return this._ldc(((Float)value).floatValue());
        }
        if (value instanceof Integer) {
            return this._ldc((Integer)value);
        }
        if (value instanceof Long) {
            return this._ldc((Long)value);
        }
        if (value instanceof Short) {
            return this._ldc((Short)value);
        }
        if (value instanceof Boolean) {
            return this._ldc((Boolean)value);
        }
        if (value instanceof Character) {
            return this._ldc(((Character)value).charValue());
        }
        if (value instanceof String) {
            return this._ldc((String)value);
        }
        if (value instanceof Type) {
            return this._ldc((Type)value);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value).toString());
    }

    @Pure
    public GeneratorAdapter getGa() {
        return this.ga;
    }

    public void setGa(GeneratorAdapter ga) {
        this.ga = ga;
    }

    @Pure
    public ClassEntity getClassEntity() {
        return this.classEntity;
    }

    public void setClassEntity(ClassEntity classEntity) {
        this.classEntity = classEntity;
    }

    @Pure
    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    @Pure
    public ConcurrentHashMap<String, Variable> getLocalVariable() {
        return this.localVariable;
    }

    public static interface Instruct {
        public void coding(CreateMethod var1);
    }

    @Accessors
    public static final class Variable {
        private Integer index;
        private Type type;

        public Variable(Integer index, Type type) {
            this.index = index;
            this.type = type;
        }

        @Pure
        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        @Pure
        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }
    }
}

