/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.guice;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import cool.taomu.asm.CreateClass;
import cool.taomu.asm.CreateMethod;
import cool.taomu.asm.entity.ClassEntity;
import cool.taomu.asm.entity.MethodEntity;
import cool.taomu.guice.BinderRule;
import cool.taomu.guice.ann.Binder;
import cool.taomu.guice.ann.Binders;
import cool.taomu.guice.ann.BindersImpl;
import cool.taomu.guice.ann.Box;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaomuGuice {
    private static final Logger LOG = LoggerFactory.getLogger(TaomuGuice.class);
    private static final ConcurrentSkipListMap<String, Injector> cacheInjector = new ConcurrentSkipListMap();
    private static final ConcurrentSkipListMap<String, Class<? extends Module>> cacheModule = new ConcurrentSkipListMap();
    private static final ConcurrentSkipListMap<String, Binders> cacheBinders = new ConcurrentSkipListMap();

    public static Injector entry(Class<?> zlass) throws CreationException {
        return TaomuGuice.entry("default", false, zlass);
    }

    public static Injector entry(String name, Class<?> zlass) throws CreationException {
        return TaomuGuice.entry(name, false, zlass);
    }

    public static Injector entry(String name, boolean isDebug, Class<?> zlass) throws CreationException {
        try {
            boolean _greaterThan;
            String key = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{name})), (CharSequence)"<=>");
            boolean _containsKey = cacheInjector.containsKey(key);
            if (_containsKey) {
                return cacheInjector.get(key);
            }
            Box box = zlass.getAnnotation(Box.class);
            Binders binders = zlass.getAnnotation(Binders.class);
            Binder binder = zlass.getAnnotation(Binder.class);
            if (box != null) {
                Consumer<Binders> _function = it -> {
                    boolean _not;
                    LOG.info("box name:{}", (Object)it.name());
                    boolean _containsKey_1 = cacheBinders.containsKey(it.name());
                    boolean bl = _not = !_containsKey_1;
                    if (_not) {
                        cacheBinders.put(it.name(), (Binders)it);
                    }
                };
                ((List)Conversions.doWrapArray((Object)box.value())).forEach(_function);
            } else if (binders != null) {
                boolean _not;
                LOG.info("name:{}", (Object)binders.name());
                boolean _containsKey_1 = cacheBinders.containsKey(binders.name());
                boolean bl = _not = !_containsKey_1;
                if (_not) {
                    cacheBinders.put(binders.name(), binders);
                }
            } else if (binder != null) {
                boolean _not_1;
                boolean _containsKey_2 = cacheBinders.containsKey("default");
                boolean bl = _not_1 = !_containsKey_2;
                if (_not_1) {
                    BindersImpl _bindersImpl = new BindersImpl("default", new Binder[]{binder});
                    cacheBinders.put("default", _bindersImpl);
                }
            }
            int _size = cacheBinders.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Consumer<Binders> _function_1 = it -> {
                    boolean _not_2;
                    boolean _containsKey_3 = cacheModule.containsKey(it.name());
                    boolean bl = _not_2 = !_containsKey_3;
                    if (_not_2) {
                        LOG.info("build :{}", (Object)it.name());
                        cacheModule.put(it.name(), TaomuGuice.buildModule(it, isDebug));
                    }
                };
                cacheBinders.values().forEach(_function_1);
            }
            LOG.info("key:{}", (Object)key);
            Class<? extends Module> module = cacheModule.get(key);
            Injector injector = Guice.createInjector((Module[])new Module[]{module.newInstance()});
            return cacheInjector.getOrDefault(key, injector);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Class<? extends Module> buildModule(Binders binders, boolean isDebug) {
        try {
            if (binders != null) {
                boolean _not;
                String name = UUID.randomUUID().toString().replace("-", "");
                String moduleName = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"Taomu", name, "Module"})), (CharSequence)"");
                ClassEntity classEntity = new ClassEntity("cool.taomu.guice", moduleName);
                classEntity.setSuperclass(Type.getType(AbstractModule.class).getInternalName());
                CreateClass cc = CreateClass.Class(classEntity, 52, isDebug);
                cc.constructor(AbstractModule.class.getConstructors());
                MethodEntity methodEntity = new MethodEntity("void configure()");
                MethodEntity binder = new MethodEntity("com/google/inject/Binder binder()", true);
                CreateMethod cm = cc.method(methodEntity).This().invokeVirtual(binder).store("binder", com.google.inject.Binder.class);
                boolean _equals = binders.properties().equals("");
                boolean bl = _not = !_equals;
                if (_not) {
                    cm.load("binder");
                    cm.ldc(binders.properties());
                    MethodEntity _methodEntity = new MethodEntity("cool/taomu/util/PropertyUtils", "java/util/Properties load(java/lang/String)", true);
                    cm.invokeStatic(_methodEntity);
                    MethodEntity _methodEntity_1 = new MethodEntity("com/google/inject/name/Names", "void bindProperties(com/google/inject/Binder,java/util/Properties)", true);
                    cm.invokeStatic(_methodEntity_1);
                }
                Consumer<String> _function = it -> {
                    LOG.info("dependence");
                    boolean _containsKey = cacheModule.containsKey(it);
                    if (_containsKey) {
                        Class<? extends Module> m = cacheModule.get(it);
                        cm.ldc(m.getName());
                        MethodEntity _methodEntity_2 = new MethodEntity("cool/taomu/asm/CreateClass", "java/lang/Class loadZlass(java/lang/String)", true);
                        cm.invokeStatic(_methodEntity_2);
                        MethodEntity _methodEntity_3 = new MethodEntity("java/lang/Class", "java/lang/Object newInstance()", true);
                        cm.invokeVirtual(_methodEntity_3);
                        cm.store("cmodule", Object.class);
                        cm.load("binder");
                        cm.load("cmodule");
                        cm.checkCast(Module.class);
                        MethodEntity _methodEntity_4 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
                        cm.invokeInterface(_methodEntity_4);
                    } else {
                        boolean _containsKey_1 = cacheBinders.containsKey(it);
                        if (_containsKey_1) {
                            Binders bs = cacheBinders.get(it);
                            cacheModule.put(bs.name(), TaomuGuice.buildModule(bs, isDebug));
                            cm.ldc(bs.name());
                            MethodEntity _methodEntity_5 = new MethodEntity("cool/taomu/asm/CreateClass", "java/lang/Class loadZlass(java/lang/String)", true);
                            cm.invokeStatic(_methodEntity_5);
                            MethodEntity _methodEntity_6 = new MethodEntity("java/lang/Class", "java/lang/Object newInstance()", true);
                            cm.invokeVirtual(_methodEntity_6);
                            cm.store("cmodule", Object.class);
                            cm.load("binder");
                            cm.load("cmodule");
                            cm.checkCast(Module.class);
                            MethodEntity _methodEntity_7 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
                            cm.invokeInterface(_methodEntity_7);
                        }
                    }
                };
                IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)binders.dependence()))).forEach(_function);
                Consumer<Class> _function_1 = it -> {
                    cm.NEW((Class<?>)it);
                    cm.dup();
                    String _name = it.getName();
                    MethodEntity _methodEntity_2 = new MethodEntity(_name, "void <init>()");
                    cm.invokeSpecial(_methodEntity_2);
                    cm.store(it.getName(), (Class<?>)it);
                    cm.load("binder");
                    cm.load(it.getName());
                    MethodEntity _methodEntity_3 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
                    cm.invokeInterface(_methodEntity_3);
                };
                IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray(binders.installs()))).forEach(_function_1);
                BinderRule.rule(cm, binders.value());
                cm.returnValue().endMethod();
                cc.end();
                LOG.info("end");
                Class<?> _loadClass = cc.loadClass(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"cool.taomu.guice", moduleName})), (CharSequence)"."));
                return _loadClass;
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

