/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.util;

import cool.taomu.guice.TaomuGuice;
import cool.taomu.guice.ann.Binder;
import cool.taomu.guice.ann.Binders;
import cool.taomu.guice.ann.Box;
import cool.taomu.util.ITaomuServiceLoader;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaomuServiceLoader<E>
implements ITaomuServiceLoader<E> {
    private static final Logger LOG = LoggerFactory.getLogger(TaomuServiceLoader.class);
    private final ConcurrentSkipListMap<String, E> providers = new ConcurrentSkipListMap();
    private Class<E> zlass;
    private ClassLoader loader;

    public TaomuServiceLoader(Class<E> zlass) {
        this(zlass, Thread.currentThread().getContextClassLoader());
    }

    public TaomuServiceLoader(Class<E> zlass, ClassLoader loader) {
        this.zlass = zlass;
        this.loader = loader;
    }

    private synchronized void init() {
        boolean _isEmpty = this.providers.isEmpty();
        if (_isEmpty) {
            ServiceLoader<E> serviceLoader = ServiceLoader.load(this.zlass, this.loader);
            Procedures.Procedure1 _function = s -> {
                LOG.info("\u52a0\u8f7d {}", (Object)s.getClass().getName());
                if (s.getClass().getAnnotation(Box.class) != null || s.getClass().getAnnotation(Binder.class) != null || s.getClass().getAnnotation(Binders.class) != null) {
                    LOG.info("\u89e3\u6790Box");
                    Object _instance = TaomuGuice.entry(s.getClass()).getInstance(s.getClass());
                    this.providers.put(s.getClass().getName(), _instance);
                } else {
                    this.providers.put(s.getClass().getName(), s);
                }
            };
            IteratorExtensions.forEach(serviceLoader.iterator(), (Procedures.Procedure1)_function);
        }
    }

    @Override
    public E get(String name) {
        this.init();
        return this.providers.get(name);
    }

    @Override
    public Collection<E> getAll() {
        this.init();
        return this.providers.values();
    }

    @Override
    public E first() {
        this.init();
        return (E)((Object[])Conversions.unwrapArray(this.providers.values(), Object.class))[0];
    }
}

